/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.command.view;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.tools.api.command.view.AbstractZOrderRecordingCommand;

public class BringElementsForward
extends AbstractZOrderRecordingCommand {
    int newIndex = -1;

    public BringElementsForward(TransactionalEditingDomain domain, List<? extends View> elementsToBringForward, int index) {
        super(domain, elementsToBringForward);
        this.elementsToMove = this.sortSelection(this.elementsToMove);
        if (index < -1 && index > this.getChildrenSize() - 1) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.BringElementsForward_wrongIndex, this.getChildrenSize() - 1));
        }
        this.newIndex = index;
    }

    private int getChildrenSize() {
        if (this.elementsToMove.get(0) instanceof Edge && this.containerView instanceof Diagram) {
            return ((Diagram)this.containerView).getEdges().size();
        }
        return this.containerView.getChildren().size();
    }

    protected void doExecute() {
        for (View view : this.elementsToMove) {
            int oldIndex;
            EList children;
            if (view instanceof Edge && this.containerView instanceof Diagram) {
                if (this.newIndex == -1) {
                    children = ((Diagram)this.containerView).getPersistedEdges();
                    oldIndex = children.indexOf((Object)view);
                    if (oldIndex >= children.size() - 1) continue;
                    ((Diagram)this.containerView).removeEdge((Edge)view);
                    ((Diagram)this.containerView).insertEdgeAt((Edge)view, oldIndex + 1);
                    continue;
                }
                ((Diagram)this.containerView).removeEdge((Edge)view);
                ((Diagram)this.containerView).insertEdgeAt((Edge)view, this.newIndex);
                continue;
            }
            children = this.containerView.getChildren();
            oldIndex = children.indexOf(view);
            if (oldIndex >= children.size() - 1) continue;
            ViewUtil.repositionChildAt((View)this.containerView, (View)view, (int)(oldIndex + 1));
        }
    }

    @Override
    protected String getCommandLabelForOneElement() {
        return Messages.BringElementsForward_oneElementLabel;
    }

    @Override
    protected String getCommandLabelForSeveralElements() {
        return Messages.BringElementsForward_severalElementsLabel;
    }
}

