/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EObjectExtensions {
    private static Logger logger = LoggerFactory.getLogger(EObjectExtensions.class);

    public static void fillDefaults(final EObject object) {
        Functions.Function1<EReference, Boolean> _function = new Functions.Function1<EReference, Boolean>(){

            public Boolean apply(EReference it) {
                return it.getLowerBound() == 1 && it.getUpperBound() == 1;
            }
        };
        Functions.Function1<EReference, Boolean> _function_1 = new Functions.Function1<EReference, Boolean>(){

            public Boolean apply(EReference it) {
                boolean _eIsSet = object.eIsSet((EStructuralFeature)it);
                return !_eIsSet;
            }
        };
        Consumer<EReference> _function_2 = new Consumer<EReference>(){

            @Override
            public void accept(EReference it) {
                try {
                    EObject value = EcoreUtil.create((EClass)it.getEReferenceType());
                    EObjectExtensions.fillDefaults(value);
                    object.eSet((EStructuralFeature)it, (Object)value);
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception e = (Exception)_t;
                        logger.error(e.getMessage());
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        };
        IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)object.eClass().getEReferences(), (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
        Functions.Function1<EAttribute, Boolean> _function_3 = new Functions.Function1<EAttribute, Boolean>(){

            public Boolean apply(EAttribute it) {
                return it.isUnsettable();
            }
        };
        Functions.Function1<EAttribute, Boolean> _function_4 = new Functions.Function1<EAttribute, Boolean>(){

            public Boolean apply(EAttribute it) {
                boolean _eIsSet = object.eIsSet((EStructuralFeature)it);
                return !_eIsSet;
            }
        };
        Consumer<EAttribute> _function_5 = new Consumer<EAttribute>(){

            @Override
            public void accept(EAttribute it) {
                object.eSet((EStructuralFeature)it, null);
            }
        };
        IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)object.eClass().getEAttributes(), (Functions.Function1)_function_3), (Functions.Function1)_function_4).forEach(_function_5);
        Consumer<EObject> _function_6 = new Consumer<EObject>(){

            @Override
            public void accept(EObject it) {
                EObjectExtensions.fillDefaults(it);
            }
        };
        object.eContents().forEach((Consumer)_function_6);
    }

    public static boolean containsUnfilledValues(final EObject object) {
        boolean _not_1;
        boolean _not;
        Functions.Function1<EReference, Boolean> _function = new Functions.Function1<EReference, Boolean>(){

            public Boolean apply(EReference it) {
                return it.getLowerBound() == 1 && it.getUpperBound() == 1;
            }
        };
        Functions.Function1<EReference, Boolean> _function_1 = new Functions.Function1<EReference, Boolean>(){

            public Boolean apply(EReference it) {
                boolean _eIsSet = object.eIsSet((EStructuralFeature)it);
                return !_eIsSet;
            }
        };
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)object.eClass().getEReferences(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return true;
        }
        Functions.Function1<EAttribute, Boolean> _function_2 = new Functions.Function1<EAttribute, Boolean>(){

            public Boolean apply(EAttribute it) {
                return it.isUnsettable();
            }
        };
        Functions.Function1<EAttribute, Boolean> _function_3 = new Functions.Function1<EAttribute, Boolean>(){

            public Boolean apply(EAttribute it) {
                boolean _eIsSet = object.eIsSet((EStructuralFeature)it);
                return !_eIsSet;
            }
        };
        boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)object.eClass().getEAttributes(), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            return true;
        }
        Functions.Function1<EObject, Boolean> _function_4 = new Functions.Function1<EObject, Boolean>(){

            public Boolean apply(EObject it) {
                return EObjectExtensions.containsUnfilledValues(it);
            }
        };
        Functions.Function2<Boolean, Boolean, Boolean> _function_5 = new Functions.Function2<Boolean, Boolean, Boolean>(){

            public Boolean apply(Boolean a, Boolean b) {
                return a != false || b != false;
            }
        };
        return (Boolean)IterableExtensions.fold((Iterable)ListExtensions.map((List)object.eContents(), (Functions.Function1)_function_4), (Object)false, (Functions.Function2)_function_5);
    }

    public static Iterable<Pair<EStructuralFeature, EObject>> getUnfilledValues(final EObject object) {
        Functions.Function1<EReference, Boolean> _function = new Functions.Function1<EReference, Boolean>(){

            public Boolean apply(EReference it) {
                return it.getLowerBound() == 1 && !it.isMany();
            }
        };
        Functions.Function1<EReference, Boolean> _function_1 = new Functions.Function1<EReference, Boolean>(){

            public Boolean apply(EReference it) {
                boolean _eIsSet = object.eIsSet((EStructuralFeature)it);
                return !_eIsSet;
            }
        };
        Iterable unsetReferences = IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)object.eClass().getEReferences(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        Functions.Function1<EAttribute, Boolean> _function_2 = new Functions.Function1<EAttribute, Boolean>(){

            public Boolean apply(EAttribute it) {
                return it.isUnsettable();
            }
        };
        Functions.Function1<EAttribute, Boolean> _function_3 = new Functions.Function1<EAttribute, Boolean>(){

            public Boolean apply(EAttribute it) {
                boolean _eIsSet = object.eIsSet((EStructuralFeature)it);
                return !_eIsSet;
            }
        };
        Iterable unsetAttributes = IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)object.eClass().getEAttributes(), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
        Functions.Function1<EStructuralFeature, Pair<EStructuralFeature, EObject>> _function_4 = new Functions.Function1<EStructuralFeature, Pair<EStructuralFeature, EObject>>(){

            public Pair<EStructuralFeature, EObject> apply(EStructuralFeature it) {
                return Pair.of((Object)it, (Object)object);
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)Iterables.concat((Iterable)unsetReferences, (Iterable)unsetAttributes), (Functions.Function1)_function_4);
        Functions.Function1<EObject, Iterable<Pair<EStructuralFeature, EObject>>> _function_5 = new Functions.Function1<EObject, Iterable<Pair<EStructuralFeature, EObject>>>(){

            public Iterable<Pair<EStructuralFeature, EObject>> apply(EObject it) {
                return EObjectExtensions.getUnfilledValues(it);
            }
        };
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)object.eContents(), (Functions.Function1)_function_5);
        return Iterables.concat((Iterable)_map, (Iterable)_flatMap);
    }

    public static String toCSV(final EObject object) {
        Functions.Function1<EAttribute, String> _function = new Functions.Function1<EAttribute, String>(){

            public String apply(EAttribute it) {
                Object attr = object.eGet((EStructuralFeature)it);
                if (attr == null) {
                    return "";
                }
                if (attr instanceof String) {
                    return ((String)attr).replace("\"", "\"\"");
                }
                return attr.toString();
            }
        };
        String _join = String.join((CharSequence)";", ListExtensions.map((List)object.eClass().getEAttributes(), (Functions.Function1)_function));
        String _lineSeparator = System.lineSeparator();
        return _join + _lineSeparator;
    }
}

