/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import org.eclipse.set.feature.siteplan.positionservice.PositionService;
import org.eclipse.set.feature.siteplan.trackservice.TrackService;
import org.eclipse.set.feature.siteplan.transform.BaseTransformator;
import org.eclipse.set.feature.siteplan.transform.Transformator;
import org.eclipse.set.model.siteplan.SiteplanFactory;
import org.eclipse.set.model.siteplan.SiteplanPackage;
import org.eclipse.set.model.siteplan.TrackClose;
import org.eclipse.set.model.siteplan.TrackCloseType;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.ENUMGleisAbschlussArt;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Gleis_Abschluss;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Gleis_Abschluss_Art_TypeClass;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Transformator.class})
public class TrackCloseTransformator
extends BaseTransformator<Gleis_Abschluss> {
    @Reference
    private TrackService trackService;
    @Reference
    private PositionService positionService;

    @Override
    public void transform(Gleis_Abschluss trackClose) {
        TrackClose result = SiteplanFactory.eINSTANCE.createTrackClose();
        result.setGuid(trackClose.getIdentitaet().getWert());
        Gleis_Abschluss_Art_TypeClass _gleisAbschlussArt = trackClose.getGleisAbschlussArt();
        ENUMGleisAbschlussArt _wert = null;
        if (_gleisAbschlussArt != null) {
            _wert = _gleisAbschlussArt.getWert();
        }
        result.setTrackCloseType(this.transformType(_wert));
        result.setPosition(this.positionService.transformPosition(this.trackService.getCoordinate((Punkt_Objekt)trackClose)));
        this.addSiteplanElement(result, SiteplanPackage.eINSTANCE.getSiteplanState_TrackClosures());
    }

    private TrackCloseType transformType(ENUMGleisAbschlussArt type) {
        if (type != null) {
            switch (type) {
                case ENUM_GLEIS_ABSCHLUSS_ART_BREMSPRELLBOCK: {
                    return TrackCloseType.FRICTION_BUFFER_STOP;
                }
                case ENUM_GLEIS_ABSCHLUSS_ART_FESTPRELLBOCK: {
                    return TrackCloseType.FIXED_BUFFER_STOP;
                }
                case ENUM_GLEIS_ABSCHLUSS_ART_KOPFRAMPE: {
                    return TrackCloseType.HEAD_RAMP;
                }
                case ENUM_GLEIS_ABSCHLUSS_ART_SCHWELLENKREUZ: {
                    return TrackCloseType.THRESHOLD_CROSS;
                }
                case ENUM_GLEIS_ABSCHLUSS_ART_DREHSCHEIBE: {
                    return TrackCloseType.TURN_TABLE;
                }
                case ENUM_GLEIS_ABSCHLUSS_ART_SCHIEBEBUEHNE: {
                    return TrackCloseType.SLIDING_STAGE;
                }
                case ENUM_GLEIS_ABSCHLUSS_ART_FAEHRANLEGER: {
                    return TrackCloseType.FERRY_DOCK;
                }
                case ENUM_GLEIS_ABSCHLUSS_ART_INFRASTRUKTURGRENZE: {
                    return TrackCloseType.INFRASTRUCTURE_BORDER;
                }
                case ENUM_GLEIS_ABSCHLUSS_ART_SONSTIGE: {
                    return TrackCloseType.OTHER;
                }
            }
            return null;
        }
        return null;
    }
}

