/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import com.google.common.base.Objects;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.feature.siteplan.positionservice.PositionService;
import org.eclipse.set.feature.siteplan.trackservice.TrackService;
import org.eclipse.set.feature.siteplan.transform.AbstractSiteplanTransformator;
import org.eclipse.set.feature.siteplan.transform.LayoutTransformator;
import org.eclipse.set.feature.siteplan.transform.SiteplanTransformator;
import org.eclipse.set.feature.siteplan.transform.TransformUtils;
import org.eclipse.set.feature.siteplan.transform.Transformator;
import org.eclipse.set.model.siteplan.Position;
import org.eclipse.set.model.siteplan.Siteplan;
import org.eclipse.set.model.siteplan.SiteplanPackage;
import org.eclipse.set.model.siteplan.SiteplanState;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.PlanungProjektExtensions;
import org.eclipse.set.ppmodel.extensions.StreckeExtensions;
import org.eclipse.set.ppmodel.extensions.StreckePunktExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.utils.GeoPosition;
import org.eclipse.set.toolboxmodel.Geodaten.ENUMGEOKoordinatensystem;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Knoten;
import org.eclipse.set.toolboxmodel.Geodaten.Strecke;
import org.eclipse.set.toolboxmodel.Geodaten.Strecke_Punkt;
import org.eclipse.set.toolboxmodel.Layoutinformationen.PlanPro_Layoutinfo;
import org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.toolboxmodel.PlanPro.Planung_G_Fuehrende_Strecke_AttributeGroup;
import org.eclipse.set.toolboxmodel.PlanPro.Planung_Gruppe;
import org.eclipse.set.toolboxmodel.PlanPro.Planung_Projekt;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={SiteplanTransformator.class})
public class SiteplanTransformatorImpl
extends AbstractSiteplanTransformator {
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(component.name=org.eclipse.set.feature.siteplan.transform.*)")
    public final List<Transformator> transformators = CollectionLiterals.newArrayList();
    @Reference
    protected TrackService trackService;
    @Reference
    protected PositionService positionService;
    private final HashMap<ArrayList<?>, SiteplanState> _createCache_transformState = CollectionLiterals.newHashMap();

    @Override
    public Siteplan transform(IModelSession modelSession) {
        Siteplan siteplan = super.transform(modelSession);
        if (siteplan == null) {
            this.trackService.clearMetaData();
            return null;
        }
        this.transformLayout(siteplan, modelSession.getPlanProSchnittstelle());
        return siteplan;
    }

    public void transformLayout(Siteplan siteplan, PlanPro_Schnittstelle schnittStelle) {
        PlanPro_Layoutinfo _planpro_layoutinfo = schnittStelle.getPlanpro_layoutinfo();
        LayoutTransformator layoutTransform = new LayoutTransformator(_planpro_layoutinfo, this.positionService);
        layoutTransform.transformLayout(siteplan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SiteplanState transformState(MultiContainer_AttributeGroup container) {
        SiteplanState _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new MultiContainer_AttributeGroup[]{container});
        HashMap<ArrayList<?>, SiteplanState> hashMap = this._createCache_transformState;
        synchronized (hashMap) {
            SiteplanState _createSiteplanState;
            if (this._createCache_transformState.containsKey(_cacheKey)) {
                return this._createCache_transformState.get(_cacheKey);
            }
            _result = _createSiteplanState = SiteplanPackage.eINSTANCE.getSiteplanFactory().createSiteplanState();
            this._createCache_transformState.put(_cacheKey, _result);
        }
        this._init_transformState(_result, container);
        return _result;
    }

    private void _init_transformState(final SiteplanState it, final MultiContainer_AttributeGroup container) {
        Procedures.Procedure1<Transformator> _function = new Procedures.Procedure1<Transformator>(){

            public void apply(Transformator transformator) {
                transformator.transformContainer(it, container);
            }
        };
        TransformUtils.createTransformatorThread(this.transformators, this.getClass().getName(), this.transformators.size(), _function);
    }

    @Override
    public Position getLeadingPosition(PlanPro_Schnittstelle planproSchnittstelle, MultiContainer_AttributeGroup container) {
        Strecke_Punkt[] startEnd;
        GeoPosition mainCoordinate;
        block12: {
            Planung_G_Fuehrende_Strecke_AttributeGroup mainRouteInfo;
            Planung_Projekt _LSTPlanungProjekt = null;
            if (planproSchnittstelle != null) {
                _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt((PlanPro_Schnittstelle)planproSchnittstelle);
            }
            Planung_Gruppe _planungGruppe = null;
            if (_LSTPlanungProjekt != null) {
                _planungGruppe = PlanungProjektExtensions.getPlanungGruppe((Planung_Projekt)_LSTPlanungProjekt);
            }
            Planung_G_Fuehrende_Strecke_AttributeGroup _planungGFuehrendeStrecke = null;
            if (_planungGruppe != null) {
                _planungGFuehrendeStrecke = _planungGruppe.getPlanungGFuehrendeStrecke();
            }
            if ((mainRouteInfo = _planungGFuehrendeStrecke) == null) {
                return null;
            }
            final String trackNumber = mainRouteInfo.getStreckeNummer().getWert();
            Functions.Function1<Strecke, Boolean> _function = new Functions.Function1<Strecke, Boolean>(){

                public Boolean apply(Strecke s) {
                    String _wert = s.getBezeichnung().getBezeichnungStrecke().getWert();
                    return Objects.equal((Object)_wert, (Object)trackNumber);
                }
            };
            Iterable mainRoutes = IterableExtensions.filter((Iterable)container.getStrecke(), (Functions.Function1)_function);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)mainRoutes);
            if (_isEmpty) {
                return null;
            }
            double trackKm = 0.0;
            try {
                trackKm = Double.parseDouble(mainRouteInfo.getStreckeKm().getWert().replace(",", ""));
            }
            catch (Throwable _t) {
                if (_t instanceof ParseException || _t instanceof NumberFormatException) {
                    return null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            Strecke mainRoute = (Strecke)IterableExtensions.head((Iterable)mainRoutes);
            try {
                mainCoordinate = StreckeExtensions.getKilometerCoordinate((Strecke)mainRoute, (double)trackKm);
                startEnd = StreckeExtensions.getStartEnd((Strecke)mainRoute);
                if (startEnd != null) break block12;
                return null;
            }
            catch (Throwable _t) {
                if (_t instanceof RuntimeException) {
                    return null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        ENUMGEOKoordinatensystem crs = GeoKnotenExtensions.getCRS((GEO_Knoten)StreckePunktExtensions.getGeoKnoten((Strecke_Punkt)((Strecke_Punkt)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)startEnd))))));
        return this.positionService.transformPosition(mainCoordinate, crs);
    }
}

