/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.set.feature.siteplan.positionservice.PositionService;
import org.eclipse.set.feature.siteplan.trackservice.TrackService;
import org.eclipse.set.feature.siteplan.transform.BaseTransformator;
import org.eclipse.set.feature.siteplan.transform.TransformUtils;
import org.eclipse.set.feature.siteplan.transform.Transformator;
import org.eclipse.set.model.siteplan.PZB;
import org.eclipse.set.model.siteplan.PZBEffectivity;
import org.eclipse.set.model.siteplan.PZBElement;
import org.eclipse.set.model.siteplan.PZBGU;
import org.eclipse.set.model.siteplan.PZBType;
import org.eclipse.set.model.siteplan.RouteObject;
import org.eclipse.set.model.siteplan.SiteplanFactory;
import org.eclipse.set.model.siteplan.SiteplanPackage;
import org.eclipse.set.ppmodel.extensions.PZBElementExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMLinksRechts;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Seitliche_Lage_TypeClass;
import org.eclipse.set.toolboxmodel.PZB.ENUMGUEAnordnung;
import org.eclipse.set.toolboxmodel.PZB.ENUMPZBArt;
import org.eclipse.set.toolboxmodel.PZB.ENUMWirksamkeit;
import org.eclipse.set.toolboxmodel.PZB.GUE_Anordnung_TypeClass;
import org.eclipse.set.toolboxmodel.PZB.GUE_Messstrecke_TypeClass;
import org.eclipse.set.toolboxmodel.PZB.PZB_Art_TypeClass;
import org.eclipse.set.toolboxmodel.PZB.PZB_Element;
import org.eclipse.set.toolboxmodel.PZB.PZB_Element_GM_AttributeGroup;
import org.eclipse.set.toolboxmodel.PZB.PZB_Element_GUE_AttributeGroup;
import org.eclipse.set.toolboxmodel.PZB.PZB_Element_Zuordnung_BP_AttributeGroup;
import org.eclipse.set.toolboxmodel.PZB.Wirksamkeit_TypeClass;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Transformator.class})
public class PZBTransformator
extends BaseTransformator<PZB_Element> {
    @Reference
    private TrackService trackService;
    @Reference
    private PositionService positionService;
    private static final double GSA_DISTANCE_AE = 7.0;
    private static final double GSA_DISTANCE_EA = 3.0;

    @Override
    public void transform(PZB_Element pzb) {
        boolean _tripleNotEquals;
        PZB_Element_GM_AttributeGroup _pZBElementGM = pzb.getPZBElementGM();
        boolean bl = _tripleNotEquals = _pZBElementGM != null;
        if (_tripleNotEquals) {
            this.addSiteplanElement(this.transformGM(pzb), SiteplanPackage.eINSTANCE.getSiteplanState_Pzb());
        } else {
            boolean _tripleNotEquals_1;
            PZB_Element_GUE_AttributeGroup _pZBElementGUE = pzb.getPZBElementGUE();
            boolean bl2 = _tripleNotEquals_1 = _pZBElementGUE != null;
            if (_tripleNotEquals_1) {
                Punkt_Objekt_TOP_Kante_AttributeGroup _get = (Punkt_Objekt_TOP_Kante_AttributeGroup)PunktObjektExtensions.getSinglePoints((Punkt_Objekt)pzb).get(0);
                Seitliche_Lage_TypeClass _seitlicheLage = null;
                if (_get != null) {
                    _seitlicheLage = _get.getSeitlicheLage();
                }
                ENUMLinksRechts _wert = null;
                if (_seitlicheLage != null) {
                    _wert = _seitlicheLage.getWert();
                }
                boolean directionFollowsTopEdge = _wert == ENUMLinksRechts.ENUM_LINKS_RECHTS_LINKS;
                final PZBGU gu = SiteplanFactory.eINSTANCE.createPZBGU();
                PZB gm = this.transformGM(pzb);
                PZB gsm = this.transformGSA(pzb, directionFollowsTopEdge);
                PZB gse = this.transformGSE(pzb, directionFollowsTopEdge);
                Consumer<PZB> _function = new Consumer<PZB>(){

                    @Override
                    public void accept(PZB it) {
                        gu.getPzbs().add((Object)it);
                    }
                };
                Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new PZB[]{gm, gsm, gse})).forEach(_function);
                GUE_Messstrecke_TypeClass length = pzb.getPZBElementGUE().getGUEMessstrecke();
                if (length != null) {
                    gu.setLength(length.getWert().intValue());
                }
                gu.setGuid(((PZB)IterableExtensions.head((Iterable)gu.getPzbs())).getGuid());
                this.addSiteplanElement(gu, SiteplanPackage.eINSTANCE.getSiteplanState_PzbGU());
            }
        }
    }

    private PZB transformPZB(PZB_Element pzb) {
        PZB result = SiteplanFactory.eINSTANCE.createPZB();
        Identitaet_TypeClass _identitaet = pzb.getIdentitaet();
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        result.setGuid(_wert);
        result.setPosition(this.positionService.transformPosition(this.trackService.getCoordinate((Punkt_Objekt)pzb)));
        PZB_Art_TypeClass _pZBArt = pzb.getPZBArt();
        ENUMPZBArt _wert_1 = null;
        if (_pZBArt != null) {
            _wert_1 = _pZBArt.getWert();
        }
        PZBElement _element = null;
        if (_wert_1 != null) {
            _element = this.toElement(_wert_1);
        }
        result.setElement(_element);
        Punkt_Objekt_TOP_Kante_AttributeGroup _get = (Punkt_Objekt_TOP_Kante_AttributeGroup)PunktObjektExtensions.getSinglePoints((Punkt_Objekt)pzb).get(0);
        Seitliche_Lage_TypeClass _seitlicheLage = null;
        if (_get != null) {
            _seitlicheLage = _get.getSeitlicheLage();
        }
        ENUMLinksRechts _wert_2 = null;
        if (_seitlicheLage != null) {
            _wert_2 = _seitlicheLage.getWert();
        }
        boolean _tripleEquals = _wert_2 == ENUMLinksRechts.ENUM_LINKS_RECHTS_RECHTS;
        result.setRightSide(_tripleEquals);
        EList pzbEl = PZBElementExtensions.getPZBElementZuordnung((PZB_Element)pzb).getPZBElementZuordnungBP();
        List _map = null;
        if (pzbEl != null) {
            Functions.Function1<PZB_Element_Zuordnung_BP_AttributeGroup, PZBEffectivity> _function = new Functions.Function1<PZB_Element_Zuordnung_BP_AttributeGroup, PZBEffectivity>(){

                public PZBEffectivity apply(PZB_Element_Zuordnung_BP_AttributeGroup it) {
                    Wirksamkeit_TypeClass _wirksamkeit = it.getWirksamkeit();
                    ENUMWirksamkeit _wert = null;
                    if (_wirksamkeit != null) {
                        _wert = _wirksamkeit.getWert();
                    }
                    PZBEffectivity _effectivity = null;
                    if (_wert != null) {
                        _effectivity = PZBTransformator.this.toEffectivity(_wert);
                    }
                    return _effectivity;
                }
            };
            _map = ListExtensions.map((List)pzbEl, (Functions.Function1)_function);
        }
        PZBEffectivity _head = null;
        if (_map != null) {
            _head = (PZBEffectivity)IterableExtensions.head(_map);
        }
        result.setEffectivity(_head);
        TransformUtils.transformPunktObjektStrecke((Punkt_Objekt)pzb, (RouteObject)result);
        return result;
    }

    private PZB transformGM(PZB_Element pzb) {
        PZB gm = this.transformPZB(pzb);
        gm.setType(PZBType.GM);
        return gm;
    }

    private PZB transformGSA(PZB_Element pzb, boolean directionFollowsTopEdge) {
        PZB_Element_GUE_AttributeGroup _pZBElementGUE = pzb.getPZBElementGUE();
        GUE_Anordnung_TypeClass _gUEAnordnung = null;
        if (_pZBElementGUE != null) {
            _gUEAnordnung = _pZBElementGUE.getGUEAnordnung();
        }
        ENUMGUEAnordnung _wert = null;
        if (_gUEAnordnung != null) {
            _wert = _gUEAnordnung.getWert();
        }
        boolean isAE = _wert == ENUMGUEAnordnung.ENUMGUE_ANORDNUNG_2AE;
        PZB_Element_GUE_AttributeGroup _pZBElementGUE_1 = pzb.getPZBElementGUE();
        GUE_Messstrecke_TypeClass _gUEMessstrecke = null;
        if (_pZBElementGUE_1 != null) {
            _gUEMessstrecke = _pZBElementGUE_1.getGUEMessstrecke();
        }
        BigDecimal _wert_1 = null;
        if (_gUEMessstrecke != null) {
            _wert_1 = _gUEMessstrecke.getWert();
        }
        double distance = _wert_1.doubleValue();
        PZB gsa = this.transformPZB(pzb);
        gsa.setType(PZBType.GUE_GSA);
        double _xifexpression = 0.0;
        _xifexpression = isAE ? 7.0 + distance : -3.0;
        double gsaDistance = _xifexpression;
        if (!directionFollowsTopEdge) {
            gsaDistance = -gsaDistance;
        }
        gsa.setPosition(this.positionService.transformPosition(this.trackService.getCoordinateAt((Punkt_Objekt)pzb, gsaDistance)));
        return gsa;
    }

    private PZB transformGSE(PZB_Element pzb, boolean directionFollowsTopEdge) {
        PZB_Element_GUE_AttributeGroup _pZBElementGUE = pzb.getPZBElementGUE();
        GUE_Messstrecke_TypeClass _gUEMessstrecke = null;
        if (_pZBElementGUE != null) {
            _gUEMessstrecke = _pZBElementGUE.getGUEMessstrecke();
        }
        BigDecimal _wert = null;
        if (_gUEMessstrecke != null) {
            _wert = _gUEMessstrecke.getWert();
        }
        double distance = _wert.doubleValue();
        PZB gse = this.transformPZB(pzb);
        gse.setType(PZBType.GUE_GSE);
        if (!directionFollowsTopEdge) {
            distance = -distance;
        }
        gse.setPosition(this.positionService.transformPosition(this.trackService.getCoordinateAt((Punkt_Objekt)pzb, distance)));
        return gse;
    }

    public PZBElement toElement(ENUMPZBArt element) {
        if (element != null) {
            switch (element) {
                case ENUMPZB_ART_1000_2000_HZ: {
                    return PZBElement.F1000_HZ2000_HZ;
                }
                case ENUMPZB_ART_1000_HZ: {
                    return PZBElement.F1000_HZ;
                }
                case ENUMPZB_ART_2000_HZ: {
                    return PZBElement.F2000_HZ;
                }
                case ENUMPZB_ART_500_HZ: {
                    return PZBElement.F500_HZ;
                }
            }
        }
        return null;
    }

    public PZBEffectivity toEffectivity(ENUMWirksamkeit value) {
        if (value != null) {
            switch (value) {
                case ENUM_WIRKSAMKEIT_SCHALTBAR_VON_SIGNAL: {
                    return PZBEffectivity.SIGNAL;
                }
                case ENUM_WIRKSAMKEIT_STAENDIG_WIRKSAM: {
                    return PZBEffectivity.ALWAYS;
                }
            }
            return PZBEffectivity.NONE;
        }
        return PZBEffectivity.NONE;
    }
}

