/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.trackservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.set.basis.geometry.Geometries;
import org.eclipse.set.basis.geometry.SegmentPosition;
import org.eclipse.set.feature.siteplan.trackservice.GEOKanteCoordinate;
import org.eclipse.set.feature.siteplan.trackservice.GEOKanteSegment;
import org.eclipse.set.ppmodel.extensions.GeoKanteExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.utils.GeoPosition;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.toolboxmodel.Basisobjekte.Begrenzung_A_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Begrenzung_B_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.ENUMGEOKoordinatensystem;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Kante_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Knoten;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Laenge_TypeClass;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;

public class GEOKanteMetadata {
    private static final double SEGMENT_THRESHOLD = 0.001;
    private final GEO_Kante geoKante;
    private final GEO_Knoten geoKnoten;
    private final LineString geometry;
    private final List<GEOKanteSegment> segments = new ArrayList<GEOKanteSegment>();
    private final double start;
    private final double length;

    public GEOKanteMetadata(GEO_Kante geoKante, final double start, double length, List<Bereich_Objekt> bereichObjekte, final TOP_Kante topKante, GEO_Knoten geoKnoten) {
        this.geoKante = geoKante;
        this.start = start;
        this.length = length;
        this.geometry = GeoKanteExtensions.getGeometry((GEO_Kante)geoKante);
        this.geoKnoten = geoKnoten;
        final double end = this.getEnd();
        GEOKanteSegment _gEOKanteSegment = new GEOKanteSegment(start, length);
        this.segments.add(_gEOKanteSegment);
        Functions.Function1<Bereich_Objekt, Boolean> _function = new Functions.Function1<Bereich_Objekt, Boolean>(){

            public Boolean apply(Bereich_Objekt bo) {
                Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, Boolean> _function = new Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, Boolean>(){

                    public Boolean apply(Bereich_Objekt_Teilbereich_AttributeGroup tb) {
                        BigDecimal begrenzungB;
                        BigDecimal begrenzungA;
                        boolean _tripleNotEquals;
                        TOP_Kante _iDTOPKante = tb.getIDTOPKante();
                        boolean bl = _tripleNotEquals = _iDTOPKante != topKante;
                        if (_tripleNotEquals) {
                            return false;
                        }
                        Begrenzung_A_TypeClass _begrenzungA = tb.getBegrenzungA();
                        BigDecimal _wert = null;
                        if (_begrenzungA != null) {
                            _wert = _begrenzungA.getWert();
                        }
                        if ((begrenzungA = _wert) == null) {
                            return false;
                        }
                        Begrenzung_B_TypeClass _begrenzungB = tb.getBegrenzungB();
                        BigDecimal _wert_1 = null;
                        if (_begrenzungB != null) {
                            _wert_1 = _begrenzungB.getWert();
                        }
                        if ((begrenzungB = _wert_1) == null) {
                            return false;
                        }
                        return true;
                    }
                };
                return IterableExtensions.exists((Iterable)bo.getBereichObjektTeilbereich(), (Functions.Function1)_function);
            }
        };
        final Iterable relevantBOs = IterableExtensions.filter(bereichObjekte, (Functions.Function1)_function);
        Consumer<Bereich_Objekt> _function_1 = new Consumer<Bereich_Objekt>(){

            @Override
            public void accept(Bereich_Objekt bo) {
                Consumer<Bereich_Objekt_Teilbereich_AttributeGroup> _function = new Consumer<Bereich_Objekt_Teilbereich_AttributeGroup>(){

                    @Override
                    public void accept(Bereich_Objekt_Teilbereich_AttributeGroup tb) {
                        double tbStart = tb.getBegrenzungA().getWert().doubleValue();
                        double tbEnd = tb.getBegrenzungB().getWert().doubleValue();
                        if (tbStart > end || tbEnd < start) {
                            return;
                        }
                        if (!(tbStart <= start) || !(tbEnd >= end)) {
                            if (tbStart >= start && tbEnd <= end) {
                                GEOKanteMetadata.this.splitSegmentsAt(tbStart);
                                GEOKanteMetadata.this.splitSegmentsAt(tbEnd);
                            } else if (tbStart <= start && tbEnd <= end) {
                                GEOKanteMetadata.this.splitSegmentsAt(tbEnd);
                            } else if (tbStart >= start && tbEnd >= end) {
                                GEOKanteMetadata.this.splitSegmentsAt(tbStart);
                            }
                        }
                    }
                };
                bo.getBereichObjektTeilbereich().forEach((Consumer)_function);
            }
        };
        relevantBOs.forEach(_function_1);
        Consumer<GEOKanteSegment> _function_2 = new Consumer<GEOKanteSegment>(){

            @Override
            public void accept(final GEOKanteSegment segment) {
                final double segStart = segment.getStart();
                final double segEnd = segment.getEnd();
                Consumer<Bereich_Objekt> _function = new Consumer<Bereich_Objekt>(){

                    @Override
                    public void accept(final Bereich_Objekt bo) {
                        Consumer<Bereich_Objekt_Teilbereich_AttributeGroup> _function = new Consumer<Bereich_Objekt_Teilbereich_AttributeGroup>(){

                            @Override
                            public void accept(Bereich_Objekt_Teilbereich_AttributeGroup tb) {
                                double tbStart = tb.getBegrenzungA().getWert().doubleValue();
                                double tbEnd = tb.getBegrenzungB().getWert().doubleValue();
                                if (tbStart > end || tbEnd < start) {
                                    return;
                                }
                                if (tbStart > segEnd) {
                                    return;
                                }
                                if (tbEnd < segStart) {
                                    return;
                                }
                                segment.getBereichObjekte().add(bo);
                            }
                        };
                        bo.getBereichObjektTeilbereich().forEach((Consumer)_function);
                    }
                };
                relevantBOs.forEach(_function);
            }
        };
        this.segments.forEach(_function_2);
    }

    public GEOKanteMetadata(GEO_Kante geoKante, double start, GEO_Knoten geoKnoten) {
        this.geoKante = geoKante;
        this.start = start;
        BigDecimal _elvis = null;
        GEO_Kante_Allg_AttributeGroup _gEOKanteAllg = geoKante.getGEOKanteAllg();
        GEO_Laenge_TypeClass _gEOLaenge = null;
        if (_gEOKanteAllg != null) {
            _gEOLaenge = _gEOKanteAllg.getGEOLaenge();
        }
        BigDecimal _wert = null;
        if (_gEOLaenge != null) {
            _wert = _gEOLaenge.getWert();
        }
        _elvis = _wert != null ? _wert : BigDecimal.ZERO;
        this.length = _elvis.doubleValue();
        this.geometry = GeoKanteExtensions.getGeometry((GEO_Kante)geoKante);
        this.geoKnoten = geoKnoten;
        GEOKanteSegment _gEOKanteSegment = new GEOKanteSegment(start, this.length);
        this.segments.add(_gEOKanteSegment);
    }

    public GEOKanteSegment getContainingSegment(final double distance) {
        Functions.Function1<GEOKanteSegment, Boolean> _function = new Functions.Function1<GEOKanteSegment, Boolean>(){

            public Boolean apply(GEOKanteSegment segment) {
                return segment.getStart() <= distance && segment.getStart() + segment.getLength() >= distance;
            }
        };
        return (GEOKanteSegment)IterableExtensions.head((Iterable)IterableExtensions.filter(this.segments, (Functions.Function1)_function));
    }

    public GEOKanteCoordinate getCoordinate(double distance, double lateralDistance, ENUMWirkrichtung wirkrichtung) {
        GEOKanteSegment segment = this.getContainingSegment(distance);
        if (segment == null) {
            throw new RuntimeException("Missing GEO_Kante segment");
        }
        double edgeLength = Math.abs(this.length);
        double geoLength = this.geometry.getLength();
        double _start = this.getStart();
        double localDistance = distance - _start;
        double scaledDistance = localDistance * (geoLength / edgeLength);
        SegmentPosition position = Geometries.getSegmentPosition((LineString)this.geometry, (Coordinate)GeoKnotenExtensions.getCoordinate((GEO_Knoten)this.geoKnoten), (double)scaledDistance);
        LineSegment tangent = GeoKanteExtensions.getTangent((GEO_Kante)this.geoKante, (SegmentPosition)position);
        GeoPosition coordinate = GeoKanteExtensions.getCoordinate((LineSegment)tangent, (SegmentPosition)position, (double)lateralDistance, (ENUMWirkrichtung)wirkrichtung);
        Set<Bereich_Objekt> _bereichObjekte = segment.getBereichObjekte();
        ENUMGEOKoordinatensystem _cRS = this.getCRS();
        return new GEOKanteCoordinate(coordinate, _bereichObjekte, _cRS);
    }

    private void splitSegmentsAt(double distance) {
        GEOKanteSegment originalSegment = this.getContainingSegment(distance);
        if (originalSegment == null) {
            throw new RuntimeException("Missing GEO_Kante segment");
        }
        GEOKanteSegment nextSegment = new GEOKanteSegment(originalSegment);
        double _start = originalSegment.getStart();
        double firstSegmentLength = distance - _start;
        double _end = originalSegment.getEnd();
        double secondSegmentLength = _end - distance;
        if (firstSegmentLength < 0.001 || secondSegmentLength < 0.001) {
            return;
        }
        originalSegment.setLength(firstSegmentLength);
        nextSegment.setStart(distance);
        nextSegment.setLength(secondSegmentLength);
        this.segments.add(nextSegment);
    }

    public double getEnd() {
        return this.start + this.length;
    }

    public double getStart() {
        return this.start;
    }

    public double getLength() {
        return this.length;
    }

    public List<GEOKanteSegment> getSegments() {
        return this.segments;
    }

    public ENUMGEOKoordinatensystem getCRS() {
        return GeoKnotenExtensions.getCRS((GEO_Knoten)this.geoKnoten);
    }

    public GEO_Kante getGeoKante() {
        return this.geoKante;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }
}

