/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.set.feature.siteplan.TrackSwitchMetadata;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.ENUMWKrArt;

public class TrackSwitchMetadataProvider {
    private static final String CSV_PATH = "data/Weichenbauformen.csv";
    private final Map<ENUMWKrArt, List<TrackSwitchMetadata>> metadata = new EnumMap<ENUMWKrArt, List<TrackSwitchMetadata>>(ENUMWKrArt.class);

    public void initialize() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<String> stream = Files.lines(Paths.get(CSV_PATH, new String[0]));){
            stream.skip(8L).forEach(line -> {
                TrackSwitchMetadata entry = TrackSwitchMetadata.fromCSVLine(line);
                if (entry != null) {
                    this.metadata.putIfAbsent(entry.type, new ArrayList());
                    this.metadata.get(entry.type).add(entry);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public TrackSwitchMetadata getTrackSwitchMetadata(ENUMWKrArt type, String design) {
        List<TrackSwitchMetadata> md = this.metadata.get(type);
        if (md == null) {
            return null;
        }
        for (TrackSwitchMetadata entry : md) {
            if (!design.equals(entry.getDesignString())) continue;
            return entry;
        }
        String designWithComma = design.replace(".", ",");
        TrackSwitchMetadata result = TrackSwitchMetadataProvider.getTrackSwitchMetadata(md, designWithComma);
        if (result != null) {
            return result;
        }
        String designNoWhitespace = designWithComma.replace(" ", "");
        result = TrackSwitchMetadataProvider.getTrackSwitchMetadata(md, designNoWhitespace);
        if (result != null) {
            return result;
        }
        String designWithPrefix = type.toString() + designNoWhitespace;
        result = TrackSwitchMetadataProvider.getTrackSwitchMetadata(md, designWithPrefix);
        return result;
    }

    private static TrackSwitchMetadata getTrackSwitchMetadata(List<TrackSwitchMetadata> md, String speziellDesign) {
        for (TrackSwitchMetadata entry : md) {
            if (!speziellDesign.equals(entry.getDesignString().replaceAll(" |\"", ""))) continue;
            return entry;
        }
        return null;
    }
}

