/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.graph;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.basis.cache.NoCache;
import org.eclipse.set.basis.graph.AbstractDigraph;
import org.eclipse.set.basis.graph.Digraph;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.basis.graph.DirectedEdgePath;
import org.eclipse.set.basis.graph.DirectedEdgePathExtension;
import org.eclipse.set.basis.graph.Routing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Digraphs {
    private static final Logger logger = LoggerFactory.getLogger(Digraphs.class);
    private static Cache edgeToSubPathCache;
    private static Supplier<Cache> edgeToSubPathCacheSupplier;

    private Digraphs() {
    }

    public static void setEdgeToSubPathCacheSupplier(Supplier<Cache> edgeToSubPathCacheSupplier) {
        Digraphs.edgeToSubPathCacheSupplier = edgeToSubPathCacheSupplier;
    }

    public static <E, N, P> Set<DirectedEdgePath<E, N, P>> getPaths(Digraph<E, N, P> digraph, Collection<P> start, Collection<P> end) {
        HashSet result = new HashSet();
        start.forEach(s -> end.forEach(e -> {
            boolean bl = result.addAll(Digraphs.getPaths(digraph, s, e));
        }));
        return result;
    }

    public static <E, N, P> Set<DirectedEdgePath<E, N, P>> getPaths(Digraph<E, N, P> digraph, P startPoint, P endPoint) {
        return digraph.getEdges().stream().filter(edge -> edge.contains(startPoint)).flatMap(startEdge -> Digraphs.getPaths(startEdge, digraph, startPoint, endPoint).stream()).collect(Collectors.toSet());
    }

    public static <E, N, P> Set<DirectedEdgePath<E, N, P>> getPaths(DirectedEdge<E, N, P> start, Routing<E, N, P> routing) {
        return Digraphs.getPaths(start, routing, -1.0);
    }

    public static <E, N, P> Set<DirectedEdgePath<E, N, P>> getPaths(DirectedEdge<E, N, P> start, Routing<E, N, P> routing, double minDistance) {
        Digraphs.createCache();
        return (Set)edgeToSubPathCache.get(Digraphs.getPathCacheKey(start, routing, minDistance), () -> Digraphs.calculateSubPaths(start, routing, minDistance));
    }

    private static <E, N, P> String getPathCacheKey(DirectedEdge<E, N, P> start, Routing<E, N, P> routing, double minDistance) {
        List<String> components = List.of(start.getCacheKey(), Double.toString(minDistance), routing.getCacheKey());
        return String.join((CharSequence)"/", components);
    }

    private static <E, N, P> Set<DirectedEdgePath<E, N, P>> calculateSubPaths(DirectedEdge<E, N, P> start, Routing<E, N, P> routing, double minDistance) {
        Set<DirectedEdgePath<DirectedEdgePath<E, N, P>, N, P>> subpaths = Digraphs.getSubPaths(start, minDistance, routing, routing.getEmptyPath());
        for (DirectedEdgePath<E, N, P> directedEdgePath : subpaths) {
            directedEdgePath.prepend(start);
        }
        if (subpaths.isEmpty()) {
            DirectedEdgePath<E, N, P> directedEdgePath = routing.getEmptyPath();
            directedEdgePath.append(start);
            subpaths.add(directedEdgePath);
        }
        return subpaths;
    }

    private static void createCache() {
        if (edgeToSubPathCache == null) {
            edgeToSubPathCache = edgeToSubPathCacheSupplier != null ? edgeToSubPathCacheSupplier.get() : new NoCache();
        }
    }

    public static <E, N, P> Set<DirectedEdgePath<E, N, P>> getPaths(DirectedEdge<E, N, P> startEdge, Routing<E, N, P> routing, P startPoint, P endPoint) {
        Set<DirectedEdgePath<E, N, P>> paths = Digraphs.getPaths(startEdge, routing);
        HashSet<DirectedEdgePath<DirectedEdgePath<E, N, P>, N, P>> routes = new HashSet<DirectedEdgePath<DirectedEdgePath<E, N, P>, N, P>>();
        for (DirectedEdgePath<E, N, P> path : paths) {
            DirectedEdgePath<E, N, P> route = path.subPath(startPoint, endPoint);
            if (route == null) continue;
            routes.add(route);
        }
        return routes;
    }

    public static <E, N, P> String prettyString(DirectedEdge<E, N, P> directedEdge) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        Iterator<P> pointIterator = directedEdge.getIterator();
        boolean isFirst = true;
        while (pointIterator.hasNext()) {
            if (!isFirst) {
                builder.append(" ");
            }
            P point = pointIterator.next();
            builder.append(Digraphs.prettyString(point));
            isFirst = false;
        }
        builder.append(")");
        return builder.toString();
    }

    public static <E, N, P> String prettyString(DirectedEdgePath<E, N, P> path) {
        return String.format("{start=%s end=%s edges=%s}", path.getStart(), path.getEnd(), Digraphs.getEdgesString(path));
    }

    public static <P> String prettyString(P point) {
        return point.toString();
    }

    public static <E, N, P> String prettyString(Set<DirectedEdgePath<E, N, P>> paths) {
        StringBuilder builder = new StringBuilder();
        for (DirectedEdgePath<E, N, P> path : paths) {
            builder.append(Digraphs.prettyString(path) + "\n");
        }
        return builder.toString();
    }

    public static <E, N, P> Digraph<E, N, P> toDigraph(Collection<DirectedEdgePath<E, N, P>> paths) {
        final DirectedEdgePath<E, N, P> aPath = paths.isEmpty() ? null : paths.iterator().next();
        return new AbstractDigraph<E, N, P>(paths){
            private Set<DirectedEdge<E, N, P>> edges = new HashSet();
            {
                for (DirectedEdgePath path : collection) {
                    List pathEdges = path.getEdgeList();
                    for (DirectedEdge pathEdge : pathEdges) {
                        this.edges.add(pathEdge);
                    }
                }
            }

            @Override
            public Comparator<Double> getDistanceComparator() {
                if (aPath != null) {
                    return aPath.getDistanceComparator();
                }
                return null;
            }

            @Override
            public Set<DirectedEdge<E, N, P>> getEdges() {
                return this.edges;
            }

            @Override
            public DirectedEdgePath<E, N, P> getEmptyPath() {
                if (aPath != null) {
                    return aPath.getEmptyPath();
                }
                return null;
            }

            @Override
            public String getCacheKey() {
                return String.join((CharSequence)"/", this.edges.stream().map(DirectedEdge::getCacheKey).toList());
            }
        };
    }

    private static <E, N, P> String getEdgesString(DirectedEdgePath<E, N, P> path) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<DirectedEdge<E, N, P>> edgeIterator = path.getEdgeIterator();
        boolean isFirst = true;
        while (edgeIterator.hasNext()) {
            if (!isFirst) {
                builder.append(" ");
            }
            DirectedEdge<E, N, P> directedEdge = edgeIterator.next();
            builder.append(Digraphs.prettyString(directedEdge));
            isFirst = false;
        }
        builder.append("]");
        return builder.toString();
    }

    private static <E, N, P> Set<DirectedEdgePath<E, N, P>> getSubPaths(DirectedEdge<E, N, P> start, double minDistance, Routing<E, N, P> routing, DirectedEdgePath<E, N, P> path) {
        logger.debug("start={} path={}", start, path);
        HashSet<DirectedEdgePath<DirectedEdgePath<E, N, P>, N, P>> result = new HashSet<DirectedEdgePath<DirectedEdgePath<E, N, P>, N, P>>();
        Set<DirectedEdge<E, N, P>> successors = routing.getDirectSuccessors(start);
        for (DirectedEdge<E, N, P> successor : successors) {
            DirectedEdgePath<E, N, P> successorPath = path.copy();
            if (DirectedEdgePathExtension.contains(path, successor)) {
                result.add(successorPath);
                continue;
            }
            successorPath.append(successor);
            Comparator<Double> comparator = routing.getDistanceComparator();
            if (comparator.compare(successorPath.getLength(), minDistance) < 0 || minDistance < 0.0) {
                Set<DirectedEdgePath<E, N, P>> subPaths = Digraphs.getSubPaths(successor, minDistance, routing, successorPath);
                if (subPaths.isEmpty()) {
                    result.add(successorPath);
                    continue;
                }
                result.addAll(subPaths);
                continue;
            }
            result.add(successorPath);
        }
        return result;
    }
}

