/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.graph;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.basis.graph.Routing;

public abstract class AbstractRouting<E, N, P>
implements Routing<E, N, P> {
    @Override
    public Set<DirectedEdge<E, N, P>> getDirectPredecessors(DirectedEdge<E, N, P> directedEdge) {
        HashSet<DirectedEdge<DirectedEdge<E, N, P>, N, P>> result = new HashSet<DirectedEdge<DirectedEdge<E, N, P>, N, P>>();
        N tail = directedEdge.getTail();
        Set<E> edges = this.getEdges(tail);
        for (E e : edges) {
            if (!this.isRoute(e, directedEdge.getElement(), tail)) continue;
            DirectedEdge<E, N, P> de = this.getHeadEdge(tail, e);
            Assert.isNotNull(de);
            result.add(de);
        }
        return result;
    }

    @Override
    public Set<DirectedEdge<E, N, P>> getDirectSuccessors(DirectedEdge<E, N, P> directedEdge) {
        HashSet<DirectedEdge<DirectedEdge<E, N, P>, N, P>> result = new HashSet<DirectedEdge<DirectedEdge<E, N, P>, N, P>>();
        N head = directedEdge.getHead();
        Set<E> edges = this.getEdges(head);
        for (E e : edges) {
            if (!this.isRoute(directedEdge.getElement(), e, head)) continue;
            DirectedEdge<E, N, P> de = this.getTailEdge(head, e);
            Assert.isNotNull(de);
            result.add(de);
        }
        return result;
    }

    @Override
    public DirectedEdge<E, N, P> getEdge(N tail, N head) {
        Set<DirectedEdge<E, N, P>> result = this.getEdges(tail, head);
        if (result.size() == 1) {
            return result.iterator().next();
        }
        return null;
    }

    public abstract Set<E> getEdges(N var1);

    @Override
    public Set<DirectedEdge<E, N, P>> getEdges(N tail, N head) {
        HashSet<DirectedEdge<DirectedEdge<E, N, P>, N, P>> result = new HashSet<DirectedEdge<DirectedEdge<E, N, P>, N, P>>();
        Set<E> edges = this.getEdges(tail);
        for (E e : edges) {
            if (!this.hasNode(e, head)) continue;
            result.add(this.getTailEdge(tail, e));
        }
        return result;
    }

    public abstract DirectedEdge<E, N, P> getHeadEdge(N var1, E var2);

    public abstract DirectedEdge<E, N, P> getTailEdge(N var1, E var2);

    public abstract boolean isRoute(E var1, E var2, N var3);

    private boolean hasNode(E e, N head) {
        return this.getEdges(head).contains(e);
    }
}

