/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.extensions;

import com.google.common.base.Objects;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.ValidationResult;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.model.model11001.Layoutinformationen.PlanPro_Layoutinfo;
import org.eclipse.set.model.model11001.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class IModelSessionExtensions {
    public static List<String> getLines(IModelSession session) throws IOException {
        boolean _tripleNotEquals;
        ToolboxFile _toolboxFile = session.getToolboxFile();
        boolean bl = _tripleNotEquals = _toolboxFile != null;
        if (_tripleNotEquals) {
            return Files.readAllLines(session.getToolboxFile().getModelPath());
        }
        return new ArrayList<String>();
    }

    public static boolean hasLoadedModel(IModelSession session) {
        return session != null && session.isLoaded();
    }

    public static boolean isXsdValid(IModelSession session) {
        return session != null && !IterableExtensions.exists(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ValidationResult[]{session.getValidationResult(PlanPro_Schnittstelle.class), session.getValidationResult(PlanPro_Layoutinfo.class)})), (Functions.Function1)new Functions.Function1<ValidationResult, Boolean>(){

            public Boolean apply(ValidationResult it) {
                ValidationResult.Outcome _xsdOutcome = it.getXsdOutcome();
                return Objects.equal((Object)((Object)_xsdOutcome), (Object)((Object)ValidationResult.Outcome.INVALID));
            }
        });
    }

    public static boolean isEmfValid(IModelSession session) {
        return session != null && !IterableExtensions.exists(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ValidationResult[]{session.getValidationResult(PlanPro_Schnittstelle.class), session.getValidationResult(PlanPro_Layoutinfo.class)})), (Functions.Function1)new Functions.Function1<ValidationResult, Boolean>(){

            public Boolean apply(ValidationResult it) {
                ValidationResult.Outcome _emfOutcome = it.getEmfOutcome();
                return Objects.equal((Object)((Object)_emfOutcome), (Object)((Object)ValidationResult.Outcome.INVALID));
            }
        });
    }

    public static String getTitleFilename(IModelSession session, String changeIndicator) {
        Path filename;
        ToolboxFile _toolboxFile = null;
        if (session != null) {
            _toolboxFile = session.getToolboxFile();
        }
        Path _path = null;
        if (_toolboxFile != null) {
            _path = _toolboxFile.getPath();
        }
        Path _fileName = null;
        if (_path != null) {
            _fileName = _path.getFileName();
        }
        if ((filename = _fileName) != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)filename);
            String _changeIndicator = IModelSessionExtensions.getChangeIndicator(session, changeIndicator);
            _builder.append(_changeIndicator);
            return _builder.toString();
        }
        return null;
    }

    private static String getChangeIndicator(IModelSession session, String changeIndicator) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isDirty = session.isDirty();
        if (_isDirty) {
            _builder.append(" ");
            _builder.append(changeIndicator);
        }
        return _builder.toString();
    }
}

