/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.set.feature.table.PlanPro2TableTransformationService;
import org.eclipse.set.feature.table.TableService;
import org.eclipse.set.feature.table.internal.TableServiceImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={IContextFunction.class}, property={"service.context.key:String=org.eclipse.set.feature.table.TableService"})
public class TableServiceContextFunction
extends ContextFunction {
    private final Map<String, PlanPro2TableTransformationService> modelServiceMap = new ConcurrentHashMap<String, PlanPro2TableTransformationService>();
    private TableServiceImpl tableService;

    public static String getElementId(Map<String, Object> properties) throws IllegalAccessException {
        Object idObject = properties.get("table.shortcut");
        if (idObject != null) {
            return idObject.toString();
        }
        throw new IllegalAccessException("table.shortcut missing in properties");
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addModelService(PlanPro2TableTransformationService service, Map<String, Object> properties) throws IllegalAccessException {
        String elementId = TableServiceContextFunction.getElementId(properties);
        if (this.tableService != null) {
            this.tableService.addModelService(service, properties);
        } else {
            this.modelServiceMap.put(elementId, service);
        }
    }

    public Object compute(IEclipseContext context, String contextKey) {
        this.tableService = (TableServiceImpl)ContextInjectionFactory.make(TableServiceImpl.class, (IEclipseContext)context);
        this.modelServiceMap.keySet().forEach(elementId -> this.tableService.addModelServiceById((String)elementId, this.modelServiceMap.get(elementId)));
        MApplication application = (MApplication)context.get(MApplication.class);
        IEclipseContext applicationContext = application.getContext();
        applicationContext.set(TableService.class, (Object)this.tableService);
        this.tableService.activate();
        return this.tableService;
    }

    public void removeModelService(PlanPro2TableTransformationService service, Map<String, Object> properties) throws IllegalAccessException {
        String elementId = TableServiceContextFunction.getElementId(properties);
        if (this.tableService != null) {
            this.tableService.removeModelService(service, properties);
        } else {
            this.modelServiceMap.remove(elementId);
        }
    }
}

