/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table.sorting;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.set.model.tablemodel.CellContent;
import org.eclipse.set.model.tablemodel.CompareCellContent;
import org.eclipse.set.model.tablemodel.StringCellContent;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.extensions.CellContentExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

abstract class AbstractCellComparator
implements Comparator<TableCell> {
    protected SortDirectionEnum direction;

    public AbstractCellComparator(SortDirectionEnum direction) {
        this.direction = direction;
    }

    @Override
    public int compare(TableCell cell1, TableCell cell2) {
        return this.compareDispatch(cell1.getContent(), cell2.getContent());
    }

    private int _compareDispatch(CellContent c1, CellContent c2) {
        StringConcatenation _builder = new StringConcatenation();
        String _simpleName = c1.getClass().getSimpleName();
        _builder.append(_simpleName);
        _builder.append(" vs. ");
        String _simpleName_1 = c2.getClass().getSimpleName();
        _builder.append(_simpleName_1);
        throw new IllegalArgumentException(_builder.toString());
    }

    private int _compareDispatch(Void c1, Void c2) {
        return 0;
    }

    private int _compareDispatch(Void c1, CellContent c2) {
        return -1;
    }

    private int _compareDispatch(CellContent c1, Void c2) {
        return 1;
    }

    private int _compareDispatch(StringCellContent c1, StringCellContent c2) {
        return this.compareCell((Iterable<String>)c1.getValue(), (Iterable<String>)c2.getValue());
    }

    private int _compareDispatch(CompareCellContent c1, CompareCellContent c2) {
        int newResult = this.compareCell((Iterable<String>)c1.getNewValue(), (Iterable<String>)c2.getNewValue());
        if (newResult != 0) {
            return newResult;
        }
        return this.compareCell((Iterable<String>)c1.getOldValue(), (Iterable<String>)c2.getOldValue());
    }

    private int _compareDispatch(StringCellContent c1, CompareCellContent c2) {
        return this.compareCell((Iterable<String>)c1.getValue(), this.compareCellContentString(c2));
    }

    private int _compareDispatch(CompareCellContent c1, StringCellContent c2) {
        return this.compareCell(this.compareCellContentString(c1), (Iterable<String>)c2.getValue());
    }

    private Iterable<String> compareCellContentString(CompareCellContent content) {
        EList _newValue = content.getNewValue();
        EList _oldValue = content.getOldValue();
        return IterableExtensions.toSet((Iterable)Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EList[]{_newValue, _oldValue}))));
    }

    public int compareCell(Iterable<String> iterable1, Iterable<String> iterable2) {
        String text1 = CellContentExtensions.iterableToString(iterable1, (String)"");
        String text2 = CellContentExtensions.iterableToString(iterable2, (String)"");
        try {
            int number1 = Integer.parseInt(text1);
            int number2 = Integer.parseInt(text2);
            return this.compareInt(number1, number2);
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                return this.compareString(text1, text2);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public abstract int compareString(String var1, String var2);

    public int compareInt(int number1, int number2) {
        boolean _equals = Objects.equal((Object)this.direction, (Object)SortDirectionEnum.ASC);
        if (_equals) {
            return Integer.valueOf(number1).compareTo(number2);
        }
        return Integer.valueOf(number2).compareTo(number1);
    }

    private int compareDispatch(CellContent c1, CellContent c2) {
        if (c1 instanceof CompareCellContent && c2 instanceof CompareCellContent) {
            return this._compareDispatch((CompareCellContent)c1, (CompareCellContent)c2);
        }
        if (c1 instanceof CompareCellContent && c2 instanceof StringCellContent) {
            return this._compareDispatch((CompareCellContent)c1, (StringCellContent)c2);
        }
        if (c1 instanceof StringCellContent && c2 instanceof CompareCellContent) {
            return this._compareDispatch((StringCellContent)c1, (CompareCellContent)c2);
        }
        if (c1 instanceof StringCellContent && c2 instanceof StringCellContent) {
            return this._compareDispatch((StringCellContent)c1, (StringCellContent)c2);
        }
        if (c1 != null && c2 != null) {
            return this._compareDispatch(c1, c2);
        }
        if (c1 != null && c2 == null) {
            return this._compareDispatch(c1, (Void)null);
        }
        if (c1 == null && c2 != null) {
            return this._compareDispatch((Void)null, c2);
        }
        return this._compareDispatch((Void)null, (Void)null);
    }
}

