/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.data.ISpanningDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.cell.DataCell;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.utils.table.TableSpanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableModelInstanceBodyDataProvider
implements ISpanningDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(TableModelInstanceBodyDataProvider.class);
    private static final String NULL_VALUE = "";
    private final List<TableRow> instances;
    private final int propertyCount;
    private final TableSpanUtils spanUtils;

    public TableModelInstanceBodyDataProvider(int propertyCount, List<TableRow> instances) {
        this.instances = instances;
        this.propertyCount = propertyCount;
        this.spanUtils = new TableSpanUtils(instances);
    }

    public int getColumnCount() {
        return this.propertyCount;
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        String value = TableRowExtensions.getRichTextValue((TableRow)this.instances.get(rowIndex), (int)columnIndex);
        if (value == null) {
            logger.debug("column={} row={} is empty", (Object)columnIndex, (Object)rowIndex);
            return NULL_VALUE;
        }
        return value;
    }

    public int getRowCount() {
        return this.instances.size();
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
    }

    public DataCell getCellByPosition(int column, int row) {
        if (!this.spanUtils.isMergeAllowed(column, row)) {
            return new DataCell(column, row, 1, 1);
        }
        int spanUp = this.spanUtils.getRowSpanUp(column, row);
        int spanDown = this.spanUtils.getRowSpanDown(column, row);
        int startRow = row - spanUp;
        int spanSize = spanUp + spanDown + 1;
        return new DataCell(column, startRow, 1, spanSize);
    }
}

