/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.xml.type.internal.XMLCalendar;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.core.services.version.PlanProVersionService;
import org.eclipse.set.feature.validation.utils.XMLNodeFinder;
import org.eclipse.set.model.validationreport.ContainerContent;
import org.eclipse.set.model.validationreport.FileInfo;
import org.eclipse.set.model.validationreport.ValidationreportFactory;
import org.w3c.dom.Node;

public class FileInfoReader {
    PlanProVersionService versionService;
    ToolboxFile toolboxFile;
    XMLNodeFinder nodeFinder;
    private static final String FILE_TIME_STAMP_NODE_NAME = "Erzeugung_Zeitstempel";
    private static final String FILE_GUID_NODE_NAME = "Identitaet";
    private static final String VALUE_NODE_NAME = "Wert";
    private static final String MODEL_XML_NAME = "content.xml";
    private static final String LAYOUT_XML_NAME = "layout.xml";
    private static final String ATTACHMENT_XML_NAME = "manifest.xml";

    public FileInfoReader(PlanProVersionService versionService, ToolboxFile toolboxFile) {
        this.versionService = versionService;
        this.toolboxFile = toolboxFile;
        this.nodeFinder = new XMLNodeFinder();
        this.nodeFinder.read(toolboxFile, toolboxFile.getModelPath());
    }

    public FileInfo getFileInfo() {
        FileInfo fileInfo = ValidationreportFactory.eINSTANCE.createFileInfo();
        fileInfo.setFileName(this.toolboxFile.getPath().toString());
        fileInfo.setUsedVersion(this.versionService.createUsedVersion(this.toolboxFile.getModelPath()));
        fileInfo.setTimeStamp(this.getFileTimeStamp());
        fileInfo.setGuid(this.getFileGuid());
        fileInfo.setChecksum(this.toolboxFile.getChecksum());
        String fileContents = this.getContainerContents().stream().map(ContainerContent::getLiteral).collect(Collectors.joining(", "));
        fileInfo.setContainerContents(fileContents);
        return fileInfo;
    }

    private String getFileTimeStamp() {
        Node timeStampValueNode = this.getValueNode(FILE_TIME_STAMP_NODE_NAME);
        if (timeStampValueNode != null) {
            XMLCalendar xmlCalendar = new XMLCalendar(timeStampValueNode.getTextContent(), 0);
            return String.format("%1$td.%1$tm.%1$tY %1$tT", xmlCalendar.toGregorianCalendar());
        }
        return null;
    }

    private String getFileGuid() {
        Node guidValueNode = this.getValueNode(FILE_GUID_NODE_NAME);
        if (guidValueNode != null) {
            return guidValueNode.getTextContent();
        }
        return null;
    }

    private Node getValueNode(String nodeName) {
        Node node = this.nodeFinder.findFirstNodeByNodeName(nodeName);
        Node valueNode = this.nodeFinder.findFirstNodeByNodeName(node, VALUE_NODE_NAME);
        if (valueNode != null) {
            return valueNode;
        }
        return null;
    }

    private List<ContainerContent> getContainerContents() {
        if (this.toolboxFile.getFormat().isPlain()) {
            return List.of(ContainerContent.MODEL);
        }
        File modelDir = this.toolboxFile.getModelPath().getParent().toFile();
        if (!modelDir.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<ContainerContent> fileContents = new ArrayList<ContainerContent>();
        Arrays.asList(modelDir.listFiles()).forEach(file -> {
            if (!file.isDirectory()) {
                String fileName = file.getName();
                if (fileName.equals(MODEL_XML_NAME)) {
                    fileContents.add(ContainerContent.MODEL);
                } else if (fileName.equals(LAYOUT_XML_NAME)) {
                    fileContents.add(ContainerContent.LAYOUT);
                } else if (fileName.equals(ATTACHMENT_XML_NAME)) {
                    fileContents.add(ContainerContent.ATTACHMENT);
                }
            }
        });
        return fileContents;
    }
}

