/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.session;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.set.basis.ToolboxPaths;
import org.eclipse.set.basis.constants.ExportType;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.feature.validation.session.ModelSession;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle;

public class ToolboxPathsImpl
implements ToolboxPaths {
    private static final String TABLE_MODEL_EXPORT_PATTERN = "%s_%s.tm";
    private static final String TABLE_PDF_EXPORT_PATTERN = "%s_%s.pdf";
    private static final String TABLE_XLSX_EXPORT_PATTERN = "%s_%s.xlsx";
    private final ModelSession modelSession;

    public ToolboxPathsImpl(ModelSession modelSession) {
        this.modelSession = modelSession;
    }

    public Path getTableModel(String shortcut, Path base, ExportType exportType) {
        return Paths.get(base.toString(), this.getTableModel(shortcut, exportType));
    }

    public Path getTablePdfExport(String shortcut, Path base, ExportType exportType) {
        return Paths.get(base.toString(), this.getTablePdfExport(shortcut, exportType));
    }

    public Path getTableXlsxExport(String shortcut, Path base, ExportType exportType) {
        return Paths.get(base.toString(), this.getTableXlsxExport(shortcut, exportType));
    }

    private String getModelBaseName(ExportType exportType) {
        Path derivedPath = PlanProSchnittstelleExtensions.getDerivedPath((PlanPro_Schnittstelle)this.modelSession.getPlanProSchnittstelle(), (String)"xxx", (String)"xxx", (ExportType)exportType);
        return PathExtensions.getBaseFileName((Path)derivedPath);
    }

    private String getTableModel(String shortcut, ExportType exportType) {
        return String.format(TABLE_MODEL_EXPORT_PATTERN, this.getModelBaseName(exportType), shortcut);
    }

    private String getTablePdfExport(String shortcut, ExportType exportType) {
        return String.format(TABLE_PDF_EXPORT_PATTERN, this.getModelBaseName(exportType), shortcut);
    }

    private String getTableXlsxExport(String shortcut, ExportType exportType) {
        return String.format(TABLE_XLSX_EXPORT_PATTERN, this.getModelBaseName(exportType), shortcut);
    }
}

