/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.graph;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.eclipse.set.basis.constants.ContainerType;
import org.eclipse.set.basis.graph.TopPath;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.core.services.graph.BankService;
import org.eclipse.set.core.services.graph.TopologicalGraphService;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.graph.TopObjectIterator;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehung;
import org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehungslinie;
import org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(property={"event.topics=modelsession/change/topmodel"}, service={EventHandler.class, BankService.class})
public class BankServiceImpl
implements BankService,
EventHandler {
    @Reference
    private TopologicalGraphService topGraph;
    private HashMap<TOP_Kante, Set<BankService.BankingInformation>> topEdgeBanking;

    public void handleEvent(Event event) {
        PlanPro_Schnittstelle planProSchnittstelle = (PlanPro_Schnittstelle)event.getProperty("org.eclipse.e4.data");
        this.topEdgeBanking = new HashMap();
        this.addBankingForContainer(PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planProSchnittstelle, (ContainerType)ContainerType.INITIAL));
        this.addBankingForContainer(PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planProSchnittstelle, (ContainerType)ContainerType.FINAL));
        this.addBankingForContainer(PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planProSchnittstelle, (ContainerType)ContainerType.SINGLE));
    }

    private void addBankingForContainer(MultiContainer_AttributeGroup container) {
        if (container == null) {
            return;
        }
        StreamSupport.stream(container.getUeberhoehungslinie().spliterator(), false).map(this::findTOPBanking).filter(Objects::nonNull).forEach(info -> info.path().edges().forEach(edge -> {
            this.topEdgeBanking.putIfAbsent((TOP_Kante)edge, new HashSet());
            this.topEdgeBanking.get(edge).add((BankService.BankingInformation)info);
        }));
    }

    public BankService.BankingInformation findTOPBanking(Ueberhoehungslinie bankingLine) {
        BigDecimal distanceB;
        BigDecimal distanceA;
        BigDecimal topLengthDifference;
        Ueberhoehung begin = bankingLine.getIDUeberhoehungA();
        Ueberhoehung end = bankingLine.getIDUeberhoehungB();
        BigDecimal bankingLineLength = bankingLine.getUeberhoehungslinieAllg().getUeberhoehungslinieLaenge().getWert();
        TOP_Kante beginEdge = ((Punkt_Objekt_TOP_Kante_AttributeGroup)begin.getPunktObjektTOPKante().get(0)).getIDTOPKante();
        if (beginEdge.equals(((Punkt_Objekt_TOP_Kante_AttributeGroup)end.getPunktObjektTOPKante().get(0)).getIDTOPKante()) && (topLengthDifference = (distanceA = ((Punkt_Objekt_TOP_Kante_AttributeGroup)begin.getPunktObjektTOPKante().get(0)).getAbstand().getWert()).subtract(distanceB = ((Punkt_Objekt_TOP_Kante_AttributeGroup)end.getPunktObjektTOPKante().get(0)).getAbstand().getWert()).abs().subtract(bankingLineLength).abs()).doubleValue() <= ToolboxConfiguration.getBankLineTopOffsetLimit()) {
            return new BankService.BankingInformation(bankingLine, new TopPath(List.of(beginEdge), beginEdge.getTOPKanteAllg().getTOPLaenge().getWert(), BigDecimal.ZERO));
        }
        int limit = (int)(bankingLineLength.doubleValue() + ToolboxConfiguration.getBankLineTopOffsetLimit() + 1.0);
        List paths = this.topGraph.findAllPathsBetween(new TopPoint((Punkt_Objekt)begin), new TopPoint((Punkt_Objekt)end), limit);
        TopPath path = null;
        double minLengthDiff = Double.MAX_VALUE;
        for (TopPath foundPath : paths) {
            double diff = Math.abs(foundPath.length().doubleValue() - bankingLineLength.doubleValue());
            if (!(diff < minLengthDiff)) continue;
            minLengthDiff = diff;
            path = foundPath;
        }
        if (path == null || minLengthDiff > ToolboxConfiguration.getBankLineTopOffsetLimit()) {
            return null;
        }
        return new BankService.BankingInformation(bankingLine, path);
    }

    public List<BankService.BankingInformation> findRelevantLineBankings(TopPoint point) {
        Set<BankService.BankingInformation> bankingLines = this.topEdgeBanking.get(point.edge());
        return bankingLines.stream().filter(line -> line.isOnBankingLine(point)).toList();
    }

    public List<BigDecimal> findBankValue(TopPoint point) {
        List<BigDecimal> lineBankings;
        if (this.topEdgeBanking.containsKey(point.edge()) && !(lineBankings = this.findRelevantLineBankings(point).stream().map(line -> BankServiceImpl.findBankingValue(point, line)).toList()).isEmpty()) {
            return lineBankings;
        }
        BigDecimal pointDistance = point.distance();
        Optional left = TopObjectIterator.getEdgeObjectsFromPoint((TOP_Kante)point.edge(), (boolean)false, (BigDecimal)pointDistance, Ueberhoehung.class).findFirst();
        Optional right = TopObjectIterator.getEdgeObjectsFromPoint((TOP_Kante)point.edge(), (boolean)true, (BigDecimal)pointDistance, Ueberhoehung.class).findFirst();
        if (!left.isPresent() || !right.isPresent()) {
            if (left.isPresent()) {
                return List.of(((Ueberhoehung)left.get()).getUeberhoehungAllg().getUeberhoehungHoehe().getWert());
            }
            if (right.isPresent()) {
                return List.of(((Ueberhoehung)right.get()).getUeberhoehungAllg().getUeberhoehungHoehe().getWert());
            }
            return List.of();
        }
        BigDecimal ueLeft = ((Ueberhoehung)left.get()).getUeberhoehungAllg().getUeberhoehungHoehe().getWert();
        BigDecimal ueRight = ((Ueberhoehung)right.get()).getUeberhoehungAllg().getUeberhoehungHoehe().getWert();
        BigDecimal leftPosition = ((Punkt_Objekt_TOP_Kante_AttributeGroup)((Ueberhoehung)left.get()).getPunktObjektTOPKante().get(0)).getAbstand().getWert();
        BigDecimal rightPosition = ((Punkt_Objekt_TOP_Kante_AttributeGroup)((Ueberhoehung)right.get()).getPunktObjektTOPKante().get(0)).getAbstand().getWert();
        BigDecimal length = leftPosition.subtract(rightPosition).abs();
        BigDecimal distanceLeft = leftPosition.subtract(pointDistance).abs();
        return List.of(BankServiceImpl.bankingDefault(ueRight.subtract(ueLeft), distanceLeft, length).add(ueLeft));
    }

    static BigDecimal findBankingValue(TopPoint point, BankService.BankingInformation bankInfo) {
        Ueberhoehungslinie bankingLine = bankInfo.line();
        BigDecimal pointDistance = (BigDecimal)bankInfo.path().getDistance(point).orElseThrow();
        BigDecimal ueLeft = bankingLine.getIDUeberhoehungA().getUeberhoehungAllg().getUeberhoehungHoehe().getWert();
        BigDecimal ueRight = bankingLine.getIDUeberhoehungB().getUeberhoehungAllg().getUeberhoehungHoehe().getWert();
        BigDecimal length = bankingLine.getUeberhoehungslinieAllg().getUeberhoehungslinieLaenge().getWert();
        BigDecimal leftPosition = (BigDecimal)bankInfo.path().getDistance(new TopPoint((Punkt_Objekt)bankingLine.getIDUeberhoehungA())).orElseThrow();
        BigDecimal rightPosition = (BigDecimal)bankInfo.path().getDistance(new TopPoint((Punkt_Objekt)bankingLine.getIDUeberhoehungB())).orElseThrow();
        BigDecimal distanceLeft = leftPosition.subtract(pointDistance).abs();
        BigDecimal distanceRight = rightPosition.subtract(pointDistance).abs();
        return BankServiceImpl.getBanking(bankingLine, ueLeft, ueRight, distanceLeft, distanceRight, length);
    }

    static BigDecimal getBanking(Ueberhoehungslinie bankingLine, BigDecimal left, BigDecimal right, BigDecimal distanceFromLeft, BigDecimal distanceFromRight, BigDecimal length) {
        BigDecimal h_start = left;
        BigDecimal h_end = right;
        BigDecimal h_between = h_end.subtract(h_start);
        switch (bankingLine.getUeberhoehungslinieAllg().getUeberhoehungslinieForm().getWert()) {
            case ENUM_UEBERHOEHUNGSLINIE_FORM_RAMPE_BLOSS: {
                return BankServiceImpl.bankingOfRampeBloss(h_between, distanceFromLeft, length).add(h_start);
            }
            case ENUM_UEBERHOEHUNGSLINIE_FORM_RAMPE_S: {
                return BankServiceImpl.bankingOfRampeS(h_between, distanceFromLeft, distanceFromRight, length).add(h_start);
            }
        }
        return BankServiceImpl.bankingDefault(h_between, distanceFromLeft, length).add(h_start);
    }

    private static BigDecimal bankingOfRampeBloss(BigDecimal h_between, BigDecimal distanceFromLeft, BigDecimal length) {
        if (distanceFromLeft.compareTo(length.divide(BigDecimal.valueOf(2L))) > 0) {
            return BankServiceImpl.bankingDefault(h_between, distanceFromLeft, length);
        }
        BigDecimal a = h_between.multiply(BigDecimal.valueOf(3L)).multiply(distanceFromLeft.pow(2)).divide(length.pow(2), RoundingMode.HALF_EVEN);
        BigDecimal b = h_between.multiply(BigDecimal.valueOf(2L)).multiply(distanceFromLeft.pow(3)).divide(length.pow(3), RoundingMode.HALF_EVEN);
        return a.add(b.negate());
    }

    private static BigDecimal bankingOfRampeS(BigDecimal h_between, BigDecimal distanceFromLeft, BigDecimal distanceFromRight, BigDecimal length) {
        if (distanceFromLeft.compareTo(length.divide(BigDecimal.valueOf(2L))) < 1) {
            return h_between.multiply(BigDecimal.valueOf(2L)).multiply(distanceFromLeft.pow(2)).divide(length.pow(2));
        }
        return h_between.add(h_between.multiply(BigDecimal.valueOf(2L)).multiply(distanceFromRight.pow(2)).divide(length.pow(2)).negate());
    }

    private static BigDecimal bankingDefault(BigDecimal h_between, BigDecimal distanceFromLeft, BigDecimal length) {
        return h_between.multiply(distanceFromLeft).divide(length, RoundingMode.HALF_EVEN);
    }
}

