/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.about;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.set.application.Messages;
import org.eclipse.set.basis.ui.VersionInfo;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.core.services.version.AdditionalVersionService;
import org.eclipse.set.ppmodel.extensions.PlanProPackageExtensions;
import org.eclipse.set.utils.PartInitializationException;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.ToolboxVersion;
import org.eclipse.set.utils.WebNoSessionBasePart;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutPart
extends WebNoSessionBasePart {
    private static final String ABOUT_DIRECTORY = "web/about";
    private static final String ABOUT_FILENAME = "index.html";
    @Inject
    @Translation
    Messages messages;
    @Inject
    @Optional
    private AdditionalVersionService additionalVersionService;
    @Inject
    private ToolboxPartService partService;
    static final Logger LOGGER = LoggerFactory.getLogger(AboutPart.class);

    private void setupRouteHandler() {
        try {
            this.browser.serveUri("version.json", (request, response) -> {
                response.setMimeType("application/json");
                response.setStatus(200);
                response.setResponseData(new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.getVersionInformation()));
            });
            this.browser.serveUri("chrome-credits", (request, response) -> {
                this.partService.showPart("org.eclipse.set.application.about.ChromiumCreditsPart");
                response.setStatus(200);
            });
            this.browser.serveRootDirectory(Path.of(ABOUT_DIRECTORY, new String[0]));
        }
        catch (Exception e) {
            throw new PartInitializationException("Failed to setup about route handler");
        }
    }

    protected void createView(Composite parent) {
        super.createView(parent);
        this.setupRouteHandler();
        this.browser.setToolboxUrl(ABOUT_FILENAME);
    }

    private VersionInfo[] getVersionInformation() {
        ArrayList versionInfo = Lists.newArrayList();
        VersionInfo versionInfo0 = new VersionInfo();
        VersionInfo versionInfo1 = new VersionInfo();
        versionInfo0.label = this.messages.AboutHandler_ToolboxVersionLabel;
        versionInfo1.label = this.messages.AboutHandler_ModelVersionLabel;
        ToolboxVersion toolboxVersion = ToolboxConfiguration.getToolboxVersion();
        versionInfo0.version = toolboxVersion.isAvailable() ? toolboxVersion.getLongVersion() : this.messages.AboutHandler_UnknownVersion;
        versionInfo1.version = PlanProPackageExtensions.getModelVersion();
        versionInfo.add(versionInfo0);
        versionInfo.add(versionInfo1);
        if (this.additionalVersionService != null) {
            this.additionalVersionService.addInfo((List)versionInfo);
        }
        return versionInfo.toArray(new VersionInfo[0]);
    }
}

