/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.pdf;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.set.basis.FreeFieldInfo;
import org.eclipse.set.model.tablemodel.CellContent;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.CompareCellContent;
import org.eclipse.set.model.tablemodel.Footnote;
import org.eclipse.set.model.tablemodel.MultiColorCellContent;
import org.eclipse.set.model.tablemodel.MultiColorContent;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableContent;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.CellContentExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableContentExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.model.titlebox.Titlebox;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.table.TableSpanUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TableToTableDocument {
    private static final Logger logger = LoggerFactory.getLogger(TableToTableDocument.class);
    private final Document doc;
    private String tablename;
    private int groupNumber;
    private final Map<Integer, Footnote> footnotes = Maps.newHashMap();
    private TableSpanUtils spanUtils;
    private final HashMap<ArrayList<?>, Element> _createCache_transform = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Element> _createCache_transform_1 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Element> _createCache_transform_2 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Element> _createCache_transform_3 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Attr> _createCache_transformToGroupNumber = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Element> _createCache_transform_4 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Element> _createCache_transform_5 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Attr> _createCache_transformToAddressAttr = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Element> _createCache_transform_6 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Element> _createCache_transformToSignificantInformation = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Element> _createCache_transformToFootnotes = CollectionLiterals.newHashMap();

    private TableToTableDocument() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        this.doc = docBuilder.newDocument();
    }

    public static TableToTableDocument createTransformation() throws ParserConfigurationException {
        return new TableToTableDocument();
    }

    public Document transformToDocument(Table table, Titlebox titlebox, FreeFieldInfo freeFieldInfo) {
        ColumnDescriptor _rootDescriptor = null;
        if (table != null) {
            _rootDescriptor = TableExtensions.getRootDescriptor((Table)table);
        }
        String _label = null;
        if (_rootDescriptor != null) {
            _label = _rootDescriptor.getLabel();
        }
        this.tablename = _label;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("tablename=");
        _builder.append(this.tablename);
        logger.debug(_builder.toString());
        this.doc.appendChild(this.transform(table, titlebox, freeFieldInfo));
        return this.doc;
    }

    public Document transformToDocument(Titlebox titlebox) {
        this.tablename = "titlebox export";
        this.doc.appendChild(this.transform(titlebox));
        return this.doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transform(Table table, Titlebox titlebox, FreeFieldInfo freeFieldInfo) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{table, titlebox, freeFieldInfo});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transform;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transform.containsKey(_cacheKey)) {
                return this._createCache_transform.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("Table");
            this._createCache_transform.put(_cacheKey, _result);
        }
        this._init_transform(_result, table, titlebox, freeFieldInfo);
        return _result;
    }

    private void _init_transform(Element it, Table table, Titlebox titlebox, FreeFieldInfo freeFieldInfo) {
        it.appendChild(this.transform(table.getTablecontent()));
        it.appendChild(this.transformToFootnotes(this.footnotes));
        it.appendChild(this.transform(titlebox));
        it.appendChild(this.transform(freeFieldInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transform(TableContent content) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new TableContent[]{content});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transform_1;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transform_1.containsKey(_cacheKey)) {
                return this._createCache_transform_1.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("Rows");
            this._createCache_transform_1.put(_cacheKey, _result);
        }
        this._init_transform(_result, content);
        return _result;
    }

    private void _init_transform(Element it, TableContent content) {
        TableSpanUtils _tableSpanUtils;
        final Element rowsElement = it;
        final List rows = TableExtensions.getTableRows((Table)TableContentExtensions.getTable((TableContent)content));
        this.spanUtils = _tableSpanUtils = new TableSpanUtils(rows);
        Consumer<TableRow> _function = new Consumer<TableRow>(){

            @Override
            public void accept(TableRow it_1) {
                rowsElement.appendChild(TableToTableDocument.this.transform(it_1, rows));
            }
        };
        rows.forEach(_function);
        if (ToolboxConfiguration.isPdfExportTestFilling() && content.getRowgroups().isEmpty()) {
            rowsElement.appendChild(this.createTestRowElement(it, "1", content));
            rowsElement.appendChild(this.createTestRowElement(it, "2", content));
            rowsElement.appendChild(this.createTestRowElement(it, "3", content));
        }
    }

    private Element createTestRowElement(Element rowsElement, String groupNumber, TableContent content) {
        final Element rowElement = this.doc.createElement("Row");
        Attr numberAttr = this.doc.createAttribute("group-number");
        numberAttr.setValue(groupNumber);
        rowElement.setAttributeNode(numberAttr);
        Consumer<Pair<Integer, ColumnDescriptor>> _function = new Consumer<Pair<Integer, ColumnDescriptor>>(){

            @Override
            public void accept(Pair<Integer, ColumnDescriptor> it) {
                Integer _key = (Integer)it.getKey();
                int _plus = _key + 1;
                rowElement.appendChild(TableToTableDocument.this.createTestCell(_plus));
            }
        };
        IterableExtensions.indexed((Iterable)TableExtensions.getColumns((Table)TableContentExtensions.getTable((TableContent)content))).forEach(_function);
        return rowElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transform(TableRow row, List<TableRow> rows) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{row, rows});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transform_2;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transform_2.containsKey(_cacheKey)) {
                return this._createCache_transform_2.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("Row");
            this._createCache_transform_2.put(_cacheKey, _result);
        }
        this._init_transform(_result, row, rows);
        return _result;
    }

    private void _init_transform(Element it, TableRow row, List<TableRow> rows) {
        it.setAttributeNode(this.transformToGroupNumber(row, rows));
        final Element rowElement = it;
        final int rowIndex = rows.indexOf(row);
        final List cells = TableRowExtensions.getContent((TableRow)row);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("groupNumber=");
        _builder.append((Object)this.groupNumber);
        _builder.append(" (");
        boolean _hasElements = false;
        for (CellContent c : cells) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" ", "");
            }
            String _plainStringValue = CellContentExtensions.getPlainStringValue((CellContent)c);
            _builder.append(_plainStringValue);
        }
        _builder.append(")");
        logger.debug(_builder.toString());
        Consumer<Pair<Integer, CellContent>> _function = new Consumer<Pair<Integer, CellContent>>(){

            @Override
            public void accept(Pair<Integer, CellContent> it_1) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("column=");
                Integer _key = (Integer)it_1.getKey();
                _builder.append((Object)_key);
                logger.debug(_builder.toString());
                boolean isRemarkColumn = TableToTableDocument.this.isRemarkColumn((CellContent)it_1.getValue(), cells);
                int rowSpan = 1;
                boolean _isMergeAllowed = TableToTableDocument.this.spanUtils.isMergeAllowed(((Integer)it_1.getKey()).intValue(), rowIndex);
                if (_isMergeAllowed) {
                    int spanUp = TableToTableDocument.this.spanUtils.getRowSpanUp(((Integer)it_1.getKey()).intValue(), rowIndex);
                    int spanDown = TableToTableDocument.this.spanUtils.getRowSpanDown(((Integer)it_1.getKey()).intValue(), rowIndex);
                    if (spanUp == 0 && spanDown > 0) {
                        rowSpan = spanDown + 1;
                    } else if (spanUp > 0) {
                        rowSpan = 0;
                    }
                }
                if (rowSpan > 0) {
                    Integer _key_1 = (Integer)it_1.getKey();
                    int _plus = _key_1 + 1;
                    rowElement.appendChild(TableToTableDocument.this.createCell((CellContent)it_1.getValue(), _plus, rowSpan, isRemarkColumn));
                }
            }
        };
        IterableExtensions.indexed((Iterable)cells).forEach(_function);
        Consumer<Footnote> _function_1 = new Consumer<Footnote>(){

            @Override
            public void accept(Footnote it_1) {
                TableToTableDocument.this.footnotes.put(it_1.getNumber(), it_1);
            }
        };
        row.getFootnotes().forEach((Consumer)_function_1);
    }

    private Element createTestCell(int columnNumber) {
        Element cellElement = this.doc.createElement("Cell");
        cellElement.setAttributeNode(this.createColumnAttribute(columnNumber));
        cellElement.appendChild(this.createTestContent(columnNumber));
        return cellElement;
    }

    private Element _createCell(CellContent content, int columnNumber, int rowSpan, boolean isRemarkColumn) {
        Element cellElement = this.doc.createElement("Cell");
        cellElement.setAttributeNode(this.createColumnAttribute(columnNumber));
        cellElement.setAttributeNode(this.createRowSpanAttribute(rowSpan));
        cellElement.appendChild(this.createContent(content, columnNumber, isRemarkColumn));
        return cellElement;
    }

    private Element _createCell(Void content, int columnNumber, int rowSpan, boolean isRemarkColumn) {
        Element cellElement = this.doc.createElement("Cell");
        cellElement.setAttributeNode(this.createColumnAttribute(columnNumber));
        cellElement.setAttributeNode(this.createRowSpanAttribute(rowSpan));
        cellElement.appendChild(this.createContent(null, columnNumber, isRemarkColumn));
        return cellElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transform(Footnote footnote) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Footnote[]{footnote});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transform_3;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transform_3.containsKey(_cacheKey)) {
                return this._createCache_transform_3.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("Footnote");
            this._createCache_transform_3.put(_cacheKey, _result);
        }
        this._init_transform_1(_result, footnote);
        return _result;
    }

    private void _init_transform_1(Element it, Footnote footnote) {
        it.setAttributeNode(this.createFootnoteAttribute(footnote));
        it.setTextContent(footnote.getText());
    }

    private Attr createFootnoteAttribute(Footnote footnote) {
        Attr footnoteAttr = this.doc.createAttribute("footnote-number");
        footnoteAttr.setValue(Integer.toString(footnote.getNumber()));
        return footnoteAttr;
    }

    private boolean isRemarkColumn(CellContent content, List<CellContent> rowContent) {
        CellContent _last = (CellContent)IterableExtensions.last(rowContent);
        return _last == content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attr transformToGroupNumber(TableRow row, List<TableRow> rows) {
        Attr _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{row, rows});
        HashMap<ArrayList<?>, Attr> hashMap = this._createCache_transformToGroupNumber;
        synchronized (hashMap) {
            Attr _createAttribute;
            if (this._createCache_transformToGroupNumber.containsKey(_cacheKey)) {
                return this._createCache_transformToGroupNumber.get(_cacheKey);
            }
            _result = _createAttribute = this.doc.createAttribute("group-number");
            this._createCache_transformToGroupNumber.put(_cacheKey, _result);
        }
        this._init_transformToGroupNumber(_result, row, rows);
        return _result;
    }

    private void _init_transformToGroupNumber(Attr it, TableRow row, List<TableRow> rows) {
        int _plus;
        int _indexOf = rows.indexOf(row);
        this.groupNumber = _plus = _indexOf + 1;
        it.setValue(Integer.valueOf(this.groupNumber).toString());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("group-number=");
        String _value = it.getValue();
        _builder.append(_value);
        logger.debug(_builder.toString());
    }

    private String checkForTestOutput(String text, int columnNumber) {
        if (ToolboxConfiguration.isPdfExportTestFilling() && StringExtensions.isNullOrEmpty((String)text)) {
            return Integer.toString(columnNumber);
        }
        return text;
    }

    private Element createTestContent(int columnNumber) {
        Element element = this.doc.createElement("StringContent");
        element.setTextContent(Integer.toString(columnNumber));
        return element;
    }

    private Element _createContent(CellContent content, int columnNumber, boolean isRemarkColumn) {
        Element element = this.doc.createElement("StringContent");
        String stringValue = CellContentExtensions.getPlainStringValue((CellContent)content);
        String _xifexpression = null;
        _xifexpression = isRemarkColumn ? this.checkForTestOutput(stringValue, columnNumber) : org.eclipse.set.utils.StringExtensions.intersperseWithZeroSpacesSC((String)this.checkForTestOutput(stringValue, columnNumber));
        element.setTextContent(_xifexpression);
        return element;
    }

    private Element _createContent(Void content, int columnNumber, boolean isRemarkColumn) {
        Element element = this.doc.createElement("StringContent");
        element.setTextContent(this.checkForTestOutput("", columnNumber));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("no content at groupNumber=");
        _builder.append((Object)this.groupNumber);
        _builder.append(" column=");
        _builder.append((Object)columnNumber);
        logger.warn(_builder.toString());
        return element;
    }

    private Element _createContent(final CompareCellContent content, final int columnNumber, final boolean isRemarkColumn) {
        final Element element = this.doc.createElement("DiffContent");
        EList _oldValue = content.getOldValue();
        EList _newValue = content.getNewValue();
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String it) {
                Functions.Function2<String, String, Element> _function = new Functions.Function2<String, String, Element>(){

                    public Element apply(String $0, String $1) {
                        return TableToTableDocument.this.createCompareValueElement($0, $1);
                    }
                };
                Element child = (Element)CellContentExtensions.getCompareContentValueFormat((CompareCellContent)content, (Functions.Function2)_function, (String)it);
                element.appendChild(TableToTableDocument.this.addContentToElement(it, child, columnNumber, isRemarkColumn));
            }
        };
        IterableExtensions.sort((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.filterNull((Iterable)Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EList[]{_oldValue, _newValue})))))).forEach(_function);
        return element;
    }

    private Element createCompareValueElement(String warning_mark, String value) {
        boolean _matched = false;
        if (Objects.equal((Object)warning_mark, (Object)"<!-- warning-mark-black -->")) {
            _matched = true;
            return this.doc.createElement("UnchangedValue");
        }
        if (!_matched && Objects.equal((Object)warning_mark, (Object)"<!-- warning-mark-yellow -->")) {
            _matched = true;
            return this.doc.createElement("OldValue");
        }
        if (!_matched && Objects.equal((Object)warning_mark, (Object)"<!-- warning-mark-red -->")) {
            _matched = true;
            return this.doc.createElement("NewValue");
        }
        return null;
    }

    private Element _createContent(MultiColorCellContent content, int columnNumber, boolean isRemarkColumn) {
        Element element = this.doc.createElement("MultiColorContent");
        int i = 0;
        while (i < content.getValue().size()) {
            boolean _lessThan;
            element.appendChild(this.createMultiColorElement((MultiColorContent)content.getValue().get(i), columnNumber, isRemarkColumn));
            int _size = content.getValue().size();
            int _minus = _size - 1;
            boolean bl = _lessThan = i < _minus;
            if (_lessThan) {
                Element separator = this.doc.createElement("SimpleValue");
                separator.setTextContent(content.getSeparator());
                element.appendChild(separator);
            }
            ++i;
        }
        return element;
    }

    private Element createMultiColorElement(MultiColorContent content, int columnNumber, boolean isRemarkColumn) {
        boolean _tripleEquals;
        String _multiColorValue = content.getMultiColorValue();
        boolean bl = _tripleEquals = _multiColorValue == null;
        if (_tripleEquals) {
            return this.createContentElement(content.getStringFormat(), "SimpleValue", columnNumber, isRemarkColumn);
        }
        Element multiColorElement = this.createContentElement(content.getStringFormat().replace("%s", ""), "MultiColorValue", columnNumber, isRemarkColumn);
        multiColorElement.setAttribute("multicolorValue", content.getMultiColorValue());
        return multiColorElement;
    }

    private Attr createColumnAttribute(int columnNumber) {
        Attr columnAttr = this.doc.createAttribute("column-number");
        columnAttr.setValue(Integer.toString(columnNumber));
        return columnAttr;
    }

    private Attr createRowSpanAttribute(int rowSpan) {
        Attr attr = this.doc.createAttribute("number-rows-spanned");
        attr.setValue(Integer.toString(rowSpan));
        return attr;
    }

    private Element createContentElement(String content, String elementName, int columnNumber, boolean isRemarkColumn) {
        Element element = this.doc.createElement(elementName);
        return this.addContentToElement(content, element, columnNumber, isRemarkColumn);
    }

    private Element addContentToElement(String content, Element element, int columnNumber, boolean isRemarkColumn) {
        String checkOutput = this.checkForTestOutput(content, columnNumber);
        String _xifexpression = null;
        _xifexpression = isRemarkColumn ? checkOutput : org.eclipse.set.utils.StringExtensions.intersperseWithZeroSpacesSC((String)checkOutput);
        element.setTextContent(_xifexpression);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transform(Titlebox titlebox) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Titlebox[]{titlebox});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transform_4;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transform_4.containsKey(_cacheKey)) {
                return this._createCache_transform_4.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("TitleBox");
            this._createCache_transform_4.put(_cacheKey, _result);
        }
        this._init_transform_2(_result, titlebox);
        return _result;
    }

    private void _init_transform_2(Element it, Titlebox titlebox) {
        final Element titleboxElement = it;
        Consumer<Pair<Integer, String>> _function = new Consumer<Pair<Integer, String>>(){

            @Override
            public void accept(Pair<Integer, String> it_1) {
                titleboxElement.appendChild(TableToTableDocument.this.transform((Integer)it_1.getKey(), (String)it_1.getValue()));
            }
        };
        IterableExtensions.indexed((Iterable)((Iterable)Conversions.doWrapArray((Object)titlebox.getField()))).forEach(_function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transform(int index, String value) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Serializable[]{Integer.valueOf(index), value});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transform_5;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transform_5.containsKey(_cacheKey)) {
                return this._createCache_transform_5.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("Field");
            this._createCache_transform_5.put(_cacheKey, _result);
        }
        this._init_transform_1(_result, index, value);
        return _result;
    }

    private void _init_transform_1(Element it, int index, String value) {
        it.setAttributeNode(this.transformToAddressAttr(index));
        String _intersperseWithZeroSpacesSC = null;
        if (value != null) {
            _intersperseWithZeroSpacesSC = org.eclipse.set.utils.StringExtensions.intersperseWithZeroSpacesSC((String)value);
        }
        it.setTextContent(_intersperseWithZeroSpacesSC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attr transformToAddressAttr(int index) {
        Attr _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Integer[]{index});
        HashMap<ArrayList<?>, Attr> hashMap = this._createCache_transformToAddressAttr;
        synchronized (hashMap) {
            Attr _createAttribute;
            if (this._createCache_transformToAddressAttr.containsKey(_cacheKey)) {
                return this._createCache_transformToAddressAttr.get(_cacheKey);
            }
            _result = _createAttribute = this.doc.createAttribute("address");
            this._createCache_transformToAddressAttr.put(_cacheKey, _result);
        }
        this._init_transformToAddressAttr(_result, index);
        return _result;
    }

    private void _init_transformToAddressAttr(Attr it, int index) {
        int address = index + 1;
        it.setValue(Integer.valueOf(address).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transform(FreeFieldInfo freeFieldInfo) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new FreeFieldInfo[]{freeFieldInfo});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transform_6;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transform_6.containsKey(_cacheKey)) {
                return this._createCache_transform_6.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("Freefield");
            this._createCache_transform_6.put(_cacheKey, _result);
        }
        this._init_transform_3(_result, freeFieldInfo);
        return _result;
    }

    private void _init_transform_3(Element it, FreeFieldInfo freeFieldInfo) {
        String significantInformation = freeFieldInfo.getSignificantInformation();
        if (significantInformation != null) {
            it.appendChild(this.transformToSignificantInformation(significantInformation));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transformToSignificantInformation(String significantInformation) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new String[]{significantInformation});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transformToSignificantInformation;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transformToSignificantInformation.containsKey(_cacheKey)) {
                return this._createCache_transformToSignificantInformation.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("SignificantInformation");
            this._createCache_transformToSignificantInformation.put(_cacheKey, _result);
        }
        this._init_transformToSignificantInformation(_result, significantInformation);
        return _result;
    }

    private void _init_transformToSignificantInformation(Element it, String significantInformation) {
        it.setTextContent(significantInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transformToFootnotes(Map<Integer, Footnote> footnotes) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Map[]{footnotes});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transformToFootnotes;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transformToFootnotes.containsKey(_cacheKey)) {
                return this._createCache_transformToFootnotes.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("Footnotes");
            this._createCache_transformToFootnotes.put(_cacheKey, _result);
        }
        this._init_transformToFootnotes(_result, footnotes);
        return _result;
    }

    private void _init_transformToFootnotes(Element it, final Map<Integer, Footnote> footnotes) {
        final Element element = it;
        Consumer<Integer> _function = new Consumer<Integer>(){

            @Override
            public void accept(Integer it_1) {
                element.appendChild(TableToTableDocument.this.transform((Footnote)footnotes.get(it_1)));
            }
        };
        IterableExtensions.sort(footnotes.keySet()).forEach(_function);
    }

    private Element createCell(CellContent content, int columnNumber, int rowSpan, boolean isRemarkColumn) {
        if (content != null) {
            return this._createCell(content, columnNumber, rowSpan, isRemarkColumn);
        }
        if (content == null) {
            return this._createCell((Void)null, columnNumber, rowSpan, isRemarkColumn);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(content, columnNumber, rowSpan, isRemarkColumn).toString());
    }

    private Element createContent(CellContent content, int columnNumber, boolean isRemarkColumn) {
        if (content instanceof CompareCellContent) {
            return this._createContent((CompareCellContent)content, columnNumber, isRemarkColumn);
        }
        if (content instanceof MultiColorCellContent) {
            return this._createContent((MultiColorCellContent)content, columnNumber, isRemarkColumn);
        }
        if (content != null) {
            return this._createContent(content, columnNumber, isRemarkColumn);
        }
        if (content == null) {
            return this._createContent((Void)null, columnNumber, isRemarkColumn);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(content, columnNumber, isRemarkColumn).toString());
    }
}

