/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.compileservice;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.feature.table.TableService;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.services.export.TableCompileService;
import org.eclipse.set.services.table.TableDiffService;
import org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle;

public class TableCompileServiceImpl
implements TableCompileService {
    @Inject
    private TableDiffService diffService;
    @Inject
    TableService tableService;

    public Map<TableType, Table> compile(String shortcut, IModelSession modelSession) {
        HashMap<TableType, Table> result = new HashMap<TableType, Table>();
        if (PlanProSchnittstelleExtensions.isPlanning((PlanPro_Schnittstelle)modelSession.getPlanProSchnittstelle())) {
            Table start = this.tableService.transformToTable(shortcut, TableType.INITIAL, modelSession);
            Table ziel = this.tableService.transformToTable(shortcut, TableType.FINAL, modelSession);
            Table diff = this.diffService.createDiffTable(start, ziel);
            result.put(TableType.DIFF, diff);
            result.put(TableType.FINAL, ziel);
        } else {
            Table single = this.tableService.transformToTable(shortcut, TableType.SINGLE, modelSession);
            result.put(TableType.SINGLE, single);
        }
        return result;
    }
}

