/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.rcp.dialogservice;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.set.basis.files.ToolboxFileFilter;
import org.eclipse.set.core.Messages;
import org.eclipse.set.core.dialogservice.DialogServiceCommonImpl;
import org.eclipse.set.core.rcp.dialogservice.LoadInvalidSiteplanDialog;
import org.eclipse.set.custom.extensions.FileDialogExtensions;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class DialogServiceRcpImpl
extends DialogServiceCommonImpl {
    @Inject
    @Translation
    Messages messages;
    @Inject
    UISynchronize sync;
    @Inject
    @Translation
    org.eclipse.set.utils.Messages utilMessages;

    private static Optional<Path> selectFile(int style, Shell shell, List<ToolboxFileFilter> filters, Optional<Path> defaultPath, Optional<String> title) {
        FileDialog fileDialog = new FileDialog(shell, style);
        title.ifPresent(t -> fileDialog.setText(t));
        Optional<Path> parent = defaultPath.map(p -> p.getParent());
        Optional<Path> fileName = defaultPath.map(p -> p.getFileName());
        parent.ifPresent(p -> fileDialog.setFilterPath(p.toString()));
        fileName.ifPresent(f -> fileDialog.setFileName(f.toString()));
        fileDialog.setOverwrite(true);
        FileDialogExtensions.setExtensionFilters((FileDialog)fileDialog, filters);
        return Optional.ofNullable(fileDialog.open()).map(s -> Paths.get(s, new String[0]));
    }

    public boolean createCompositePlanningWithInvalidInput(Shell shell, boolean isPrimaryValid, boolean isSecondaryValid) {
        int result = MessageDialog.open((int)4, (Shell)shell, (String)this.messages.createCompositePlanningWithInvalidInputTitle, (String)String.format(this.messages.createCompositePlanningWithInvalidInputPattern, this.getPlanningDescription(isPrimaryValid, isSecondaryValid)), (int)0, (String[])new String[]{this.messages.DialogService_CreateCompositePlanningButton, this.messages.DialogService_ReturnButton});
        return result == 0;
    }

    public boolean doApplyAutofill(Shell shell, String date) {
        int buttonIndex = MessageDialog.open((int)3, (Shell)shell, (String)this.messages.DialogService_AutoFillConfirmation_Title, (String)String.format(this.messages.DialogService_AutoFillConfirmation_Pattern, date), (int)0, (String[])new String[]{this.messages.DialogService_AutoFillConfirmation_Button_Apply, this.messages.DialogService_AutoFillConfirmation_Button_NotApply});
        return buttonIndex == 0;
    }

    public void fileDownload(Shell shell, Path path) {
        throw new UnsupportedOperationException();
    }

    public void openDirectoryAfterExport(Shell shell, Path path) {
        int result = MessageDialog.open((int)2, (Shell)shell, (String)this.messages.DialogService_OpenDirectoryAfterExport_Title, (String)this.messages.DialogService_OpenDirectoryAfterExport_Message, (int)0, (String[])new String[]{IDialogConstants.OK_LABEL, this.messages.DialogService_OpenDirectoryAfterExport_ShowDir});
        if (result == 1) {
            try {
                Runtime.getRuntime().exec("explorer " + path.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Optional<Path> openFileDialog(Shell shell, List<ToolboxFileFilter> filters) {
        return DialogServiceRcpImpl.selectFile(4096, shell, filters, Optional.empty(), Optional.empty());
    }

    public Optional<Path> saveFileDialog(Shell shell, List<ToolboxFileFilter> filters) {
        return DialogServiceRcpImpl.selectFile(8192, shell, filters, Optional.empty(), Optional.empty());
    }

    public Optional<Path> saveFileDialog(Shell shell, List<ToolboxFileFilter> filters, Path defaultPath) {
        return DialogServiceRcpImpl.selectFile(8192, shell, filters, Optional.ofNullable(defaultPath), Optional.empty());
    }

    public Optional<Path> saveFileDialog(Shell shell, List<ToolboxFileFilter> filters, Path defaultPath, String title) {
        return DialogServiceRcpImpl.selectFile(8192, shell, filters, Optional.ofNullable(defaultPath), Optional.ofNullable(title));
    }

    public Optional<String> selectDirectory(Shell shell, String pathFilter) {
        File dirFile;
        DirectoryDialog directoryDialog = new DirectoryDialog(shell);
        directoryDialog.setFilterPath(pathFilter);
        directoryDialog.setMessage(this.messages.DialogService_SelectDirectory);
        String dir = directoryDialog.open();
        if (dir != null && !(dirFile = new File(dir)).exists()) {
            dirFile.mkdir();
        }
        return Optional.ofNullable(dir);
    }

    public boolean sitePlanError(Shell shell, String filename) {
        LoadInvalidSiteplanDialog dialog = new LoadInvalidSiteplanDialog(shell, filename, this.messages);
        int result = dialog.open();
        dialog.close();
        return result == 0;
    }
}

