/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.excel;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.Units;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ExcelWorkbookExtension {
    private static float FONT_SCALE_FACTOR = 1.0725f;
    private static final float CM_PER_INCH = 2.54f;

    public static Optional<Cell> getCellAt(Sheet sheet, int rowIndex, int columnIndex) {
        Row _row = sheet.getRow(rowIndex);
        Cell _cell = null;
        if (_row != null) {
            _cell = _row.getCell(columnIndex);
        }
        return Optional.ofNullable(_cell);
    }

    public static Optional<String> getCellStringValue(Optional<Cell> cell) {
        boolean _isPresent = cell.isPresent();
        if (_isPresent) {
            return ExcelWorkbookExtension.getCellStringValue(cell.get());
        }
        return Optional.empty();
    }

    public static Optional<String> getCellStringValue(Cell cell) {
        boolean _isNullOrEmpty;
        String _xifexpression = null;
        String _stringCellValue = null;
        if (cell != null) {
            _stringCellValue = cell.getStringCellValue();
        }
        _xifexpression = (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_stringCellValue)) ? null : cell.getStringCellValue();
        return Optional.ofNullable(_xifexpression);
    }

    public static Optional<CellRangeAddress> getColumnSpanRangeAt(Cell cell) {
        if (cell == null) {
            return Optional.empty();
        }
        return ExcelWorkbookExtension.getColumnSpanRangeAt(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex());
    }

    public static Optional<CellRangeAddress> getColumnSpanRangeAt(Sheet sheet, final int columnIndex, final int rowIndex) {
        Functions.Function1<CellRangeAddress, Boolean> _function = new Functions.Function1<CellRangeAddress, Boolean>(){

            public Boolean apply(CellRangeAddress it) {
                int _lastRow;
                int _firstRow = it.getFirstRow();
                return _firstRow == (_lastRow = it.getLastRow());
            }
        };
        Functions.Function1<CellRangeAddress, Boolean> _function_1 = new Functions.Function1<CellRangeAddress, Boolean>(){

            public Boolean apply(CellRangeAddress it) {
                int _firstRow = it.getFirstRow();
                return _firstRow == rowIndex;
            }
        };
        Functions.Function1<CellRangeAddress, Boolean> _function_2 = new Functions.Function1<CellRangeAddress, Boolean>(){

            public Boolean apply(CellRangeAddress it) {
                return it.getFirstColumn() <= columnIndex && it.getLastColumn() >= columnIndex;
            }
        };
        return Optional.ofNullable((CellRangeAddress)IterableExtensions.findFirst((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)sheet.getMergedRegions(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
    }

    public static float getColumnWidthInCm(Sheet sheet, int columnIndex) {
        float _columnWidthInPixels = sheet.getColumnWidthInPixels(columnIndex);
        float _multiply = _columnWidthInPixels * FONT_SCALE_FACTOR;
        int widthPX = Math.round(_multiply);
        float _floatValue = Integer.valueOf(widthPX).floatValue();
        double _doubleValue = Float.valueOf(_floatValue / 96.0f).doubleValue();
        double _multiply_1 = _doubleValue * (double)2.54f;
        double _multiply_2 = _multiply_1 * 100.0;
        long _round = Math.round(_multiply_2);
        return (float)_round / 100.0f;
    }

    public static int getHeaderLastRowIndex(Sheet sheet) {
        return sheet.getRepeatingRows().getLastRow();
    }

    public static int getHeaderLastColumnIndex(Sheet sheet) {
        int lastColumnIndex;
        Row firstRow = sheet.getRow(0);
        int i = lastColumnIndex = 1;
        while (i < firstRow.getLastCellNum()) {
            Cell cell = firstRow.getCell(i);
            boolean _isEmpty = ExcelWorkbookExtension.getCellStringValue(cell).isEmpty();
            if (_isEmpty) {
                return lastColumnIndex;
            }
            lastColumnIndex = i++;
        }
        return lastColumnIndex;
    }

    public static CellRangeAddress[] getParentGroupSpan(Sheet sheet) {
        Functions.Function1<CellRangeAddress, Boolean> _function = new Functions.Function1<CellRangeAddress, Boolean>(){

            public Boolean apply(CellRangeAddress it) {
                int _firstRow = it.getFirstRow();
                return _firstRow == 1;
            }
        };
        return (CellRangeAddress[])Conversions.unwrapArray((Object)IterableExtensions.filter((Iterable)sheet.getMergedRegions(), (Functions.Function1)_function), CellRangeAddress.class);
    }

    public static Set<Integer> getRepeatingColumns(Sheet sheet) {
        LinkedHashSet result = CollectionLiterals.newLinkedHashSet();
        if (sheet == null || sheet.getRepeatingColumns() == null) {
            return result;
        }
        CellRangeAddress repeatingRange = sheet.getRepeatingColumns();
        int i = repeatingRange.getFirstColumn();
        while (i <= repeatingRange.getLastColumn()) {
            result.add(i);
            ++i;
        }
        return result;
    }

    public static Optional<CellRangeAddress> getRowSpanRangeAt(Cell cell) {
        return ExcelWorkbookExtension.getRowSpanRangeAt(cell.getSheet(), cell.getRowIndex(), cell.getColumnIndex());
    }

    public static Optional<CellRangeAddress> getRowSpanRangeAt(Sheet sheet, final int rowIndex, final int columnIndex) {
        Functions.Function1<CellRangeAddress, Boolean> _function = new Functions.Function1<CellRangeAddress, Boolean>(){

            public Boolean apply(CellRangeAddress it) {
                int _lastColumn;
                int _firstColumn = it.getFirstColumn();
                return _firstColumn == (_lastColumn = it.getLastColumn());
            }
        };
        Functions.Function1<CellRangeAddress, Boolean> _function_1 = new Functions.Function1<CellRangeAddress, Boolean>(){

            public Boolean apply(CellRangeAddress it) {
                int _firstColumn = it.getFirstColumn();
                return _firstColumn == columnIndex;
            }
        };
        Functions.Function1<CellRangeAddress, Boolean> _function_2 = new Functions.Function1<CellRangeAddress, Boolean>(){

            public Boolean apply(CellRangeAddress it) {
                return it.getFirstRow() <= rowIndex && it.getLastRow() >= rowIndex;
            }
        };
        return Optional.ofNullable((CellRangeAddress)IterableExtensions.findFirst((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)sheet.getMergedRegions(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
    }

    public static float getRowHeightInCm(Sheet sheet, int rowIndex) {
        int height = Units.pointsToPixel((double)sheet.getRow(rowIndex).getHeightInPoints());
        int heightPx = Math.round((float)height * FONT_SCALE_FACTOR);
        float _floatValue = Integer.valueOf(heightPx).floatValue();
        float _divide = _floatValue / 96.0f;
        float _multiply = _divide * 2.54f;
        float _multiply_1 = _multiply * 100.0f;
        int _round = Math.round(_multiply_1);
        return (float)_round / 100.0f;
    }

    public static List<Cell> getFirstDataRow(final Sheet sheet) {
        int hearLastRowIndex = ExcelWorkbookExtension.getHeaderLastRowIndex(sheet);
        Row firstDataRow = sheet.getRow(hearLastRowIndex + 1);
        if (firstDataRow == null || IterableExtensions.isEmpty((Iterable)firstDataRow)) {
            return Collections.emptyList();
        }
        Functions.Function1<Cell, Boolean> _function = new Functions.Function1<Cell, Boolean>(){

            public Boolean apply(Cell it) {
                Optional<String> firstRowCellValue = ExcelWorkbookExtension.getCellStringValue(ExcelWorkbookExtension.getCellAt(sheet, 0, it.getColumnIndex()));
                return firstRowCellValue.isPresent();
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)IteratorExtensions.toList((Iterator)firstDataRow.iterator()), (Functions.Function1)_function));
    }
}

