/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.ContainerType;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.basis.extensions.MApplicationElementExtensions;
import org.eclipse.set.basis.part.ToolboxPart;
import org.eclipse.set.basis.part.ViewVisibility;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.core.services.session.SessionService;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.toolboxmodel.PlanPro.Container_AttributeGroup;
import org.eclipse.set.utils.Messages;
import org.eclipse.set.utils.SelectableAction;
import org.eclipse.set.utils.events.ContainerDataChanged;
import org.eclipse.set.utils.events.DataEvent;
import org.eclipse.set.utils.events.DefaultToolboxEventHandler;
import org.eclipse.set.utils.events.EditingCompleted;
import org.eclipse.set.utils.events.NewActiveViewEvent;
import org.eclipse.set.utils.events.NewTableTypeEvent;
import org.eclipse.set.utils.events.ProjectDataChanged;
import org.eclipse.set.utils.events.SessionDirtyChanged;
import org.eclipse.set.utils.events.ToolboxEventHandler;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.set.utils.widgets.Banderole;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePart
implements ToolboxPart {
    static final Logger LOGGER = LoggerFactory.getLogger(BasePart.class);
    private MApplication application;
    private Banderole banderole;
    @Inject
    private IEventBroker broker;
    private ToolboxEventHandler<DataEvent> dataEventHandler;
    @Inject
    private DialogService dialogService;
    @Inject
    private EnumTranslationService enumTranslationService;
    @Inject
    @Translation
    private Messages messages;
    private final List<Container_AttributeGroup> modifiedContainer = Lists.newLinkedList();
    private final List<Notification> modifiedProjectData = Lists.newLinkedList();
    private ToolboxEventHandler<NewActiveViewEvent> newActiveViewHandler;
    private ToolboxEventHandler<NewTableTypeEvent> newTableTypeHandler;
    private IModelSession session;
    private DefaultToolboxEventHandler<SessionDirtyChanged> sessionDirtyHandler;
    @Inject
    private SessionService sessionService;
    private Shell toolboxShell;
    private boolean updateViewDelayed;
    private String viewTitle;
    protected LocalResourceManager localResourceManager;
    boolean active;
    MPart toolboxPart;

    public MApplication getApplication() {
        return this.application;
    }

    public IEventBroker getBroker() {
        return this.broker;
    }

    public MultiContainer_AttributeGroup getContainerInFocus() {
        return this.session.getContainer(this.getContainerType());
    }

    public ContainerType getContainerType() {
        return null;
    }

    public DialogService getDialogService() {
        return this.dialogService;
    }

    public IModelSession getModelSession() {
        return this.session;
    }

    public SessionService getSessionService() {
        return this.sessionService;
    }

    public TableType getTableType() {
        ContainerType containerType = this.getContainerType();
        if (containerType != null) {
            return containerType.getDefaultTableType();
        }
        return null;
    }

    public MPart getToolboxPart() {
        return this.toolboxPart;
    }

    public Shell getToolboxShell() {
        return this.toolboxShell;
    }

    public Messages getUtilMessages() {
        return this.messages;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isOutdated() {
        return this.banderole.isOutdated();
    }

    public void setOutdated(boolean outdated) {
        if (outdated != this.banderole.isOutdated()) {
            this.banderole.setOutdated(outdated);
        }
    }

    @PostConstruct
    private void postConstruct(Composite parent, Shell shell, MPart part, MApplication pApplication, IModelSession modelSession) {
        try {
            this.localResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
            this.toolboxShell = shell;
            this.toolboxPart = part;
            this.viewTitle = part.getLabel();
            this.application = pApplication;
            this.session = modelSession;
            parent.setLayout((Layout)new GridLayout());
            Control title = this.createTitle(parent);
            GridDataFactory.fillDefaults().applyTo(title);
            Composite viewComposite = new Composite(parent, 0);
            viewComposite.setLayout((Layout)new GridLayout());
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)viewComposite);
            this.createView(viewComposite);
            this.newActiveViewHandler = new DefaultToolboxEventHandler<NewActiveViewEvent>(){

                @Override
                public void accept(NewActiveViewEvent e) {
                    MPart newActivePart = e.getNewActivePart();
                    if (newActivePart == BasePart.this.toolboxPart) {
                        BasePart.this.active = true;
                        LOGGER.debug(BasePart.this.toolboxPart.getElementId() + " activated.");
                        BasePart.this.handleActivation();
                    } else {
                        BasePart.this.active = false;
                        LOGGER.debug(BasePart.this.toolboxPart.getElementId() + " deactivated.");
                    }
                }
            };
            ToolboxEvents.subscribe(this.broker, NewActiveViewEvent.class, this.newActiveViewHandler);
            this.newTableTypeHandler = new DefaultToolboxEventHandler<NewTableTypeEvent>(){

                @Override
                public void accept(NewTableTypeEvent e) {
                    BasePart.this.handleNewTableType(e);
                }
            };
            ToolboxEvents.subscribe(this.broker, NewTableTypeEvent.class, this.newTableTypeHandler);
            this.dataEventHandler = new DefaultToolboxEventHandler<DataEvent>(){

                @Override
                public void accept(DataEvent e) {
                    BasePart.this.handleDataEvent(e);
                }
            };
            ToolboxEvents.subscribe(this.broker, DataEvent.class, this.dataEventHandler);
            this.sessionDirtyHandler = new DefaultToolboxEventHandler<SessionDirtyChanged>(){

                @Override
                public void accept(SessionDirtyChanged e) {
                    BasePart.this.handleSessionDirtyEvent(e);
                }
            };
            ToolboxEvents.subscribe(this.broker, SessionDirtyChanged.class, this.sessionDirtyHandler);
        }
        catch (Exception e) {
            this.dialogService.error(shell, e);
        }
    }

    @PreDestroy
    private void preDestroy() {
        ToolboxEvents.unsubscribe(this.broker, this.newActiveViewHandler);
        ToolboxEvents.unsubscribe(this.broker, this.newTableTypeHandler);
        ToolboxEvents.unsubscribe(this.broker, this.dataEventHandler);
        ToolboxEvents.unsubscribe(this.broker, this.sessionDirtyHandler);
    }

    protected Banderole createBanderole(Composite parent) {
        this.banderole = new Banderole(parent, this.messages.ViewHeading_OutdatedText, this.enumTranslationService);
        this.banderole.setHeading(this.getViewTitle());
        this.banderole.setOutdatedAction(this.getOutdatedAction());
        return this.banderole;
    }

    protected Control createTitle(Composite parent) {
        return this.createBanderole(parent).getControl();
    }

    protected abstract void createView(Composite var1);

    protected Banderole getBanderole() {
        return this.banderole;
    }

    protected SelectableAction getOutdatedAction() {
        return null;
    }

    protected String getViewTitle() {
        return this.viewTitle;
    }

    protected void handleActivation() {
        if (this.updateViewDelayed) {
            this.updateView();
        }
    }

    protected void handleContainerDataChanged(ContainerDataChanged e) {
        LOGGER.debug("{} ignored", (Object)e);
    }

    protected void handleDataEvent(DataEvent e) {
        if (e instanceof EditingCompleted) {
            this.handleEditingComplete();
        }
        if (e instanceof ProjectDataChanged) {
            ProjectDataChanged p = (ProjectDataChanged)e;
            this.modifiedProjectData.add(p.getNotification());
            this.handleProjectDataChanged(p);
        }
        if (e instanceof ContainerDataChanged) {
            ContainerDataChanged c = (ContainerDataChanged)e;
            this.modifiedContainer.add(c.getContainer());
            this.handleContainerDataChanged(c);
        }
    }

    protected void handleEditingComplete() {
        MPart part = this.getToolboxPart();
        ViewVisibility visibility = MApplicationElementExtensions.getVisibility((MApplicationElement)part);
        if (visibility == ViewVisibility.EXPOSED) {
            this.updateView();
        } else {
            this.updateViewDelayed = true;
        }
    }

    protected void handleNewTableType(NewTableTypeEvent e) {
        LOGGER.debug("{} ignored", (Object)e);
    }

    protected void handleProjectDataChanged(ProjectDataChanged e) {
        LOGGER.debug("{} ignored", (Object)e);
    }

    protected void handleSessionDirtyEvent(SessionDirtyChanged e) {
        LOGGER.debug("{} ignored", (Object)e);
    }

    protected void updateView() {
        this.updateViewDelayed = false;
        if (!this.modifiedProjectData.isEmpty() || this.banderole.isOutdated()) {
            this.updateViewProjectDataChanged(this.modifiedProjectData);
            this.modifiedProjectData.clear();
        }
        if (!this.modifiedContainer.isEmpty() || this.banderole.isOutdated()) {
            this.updateViewContainerDataChanged(this.modifiedContainer);
            this.modifiedContainer.clear();
        }
    }

    protected void updateViewContainerDataChanged(List<Container_AttributeGroup> container) {
        LOGGER.debug("update for {} ignored", container);
    }

    protected void updateViewProjectDataChanged(List<Notification> notifications) {
        LOGGER.debug("update for {} ignored", notifications);
    }
}

