/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template.ast;

import java.math.BigDecimal;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Stream;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutInterfaceApi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AbstractAstBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstMethodBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstNodeFactory;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstTypeBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.ILinkedPositionHolder;
import org.eclipse.scout.sdk.s2e.util.ast.AstUtils;

public class AstRadioButtonBuilder
extends AstTypeBuilder<AstRadioButtonBuilder> {
    public static final Set<String> PROPOSAL_RADIO_DATA_TYPES = new ConcurrentSkipListSet<String>();

    protected AstRadioButtonBuilder(AstNodeFactory owner) {
        super(owner);
    }

    @Override
    public AstRadioButtonBuilder insert() {
        String genericFromRadioButtonGroupFqn = this.parseValueTypeTypeFromGroup();
        Type genericFromRadioButtonGroupType = this.getFactory().newTypeReference(genericFromRadioButtonGroupFqn);
        ParameterizedType parameterizedType = this.getFactory().getAst().newParameterizedType(this.getSuperType());
        parameterizedType.typeArguments().add(genericFromRadioButtonGroupType);
        this.withSuperType((Type)parameterizedType);
        super.insert();
        this.addGetConfiguredRadioValue(genericFromRadioButtonGroupFqn);
        ILinkedPositionHolder links = this.getFactory().getLinkedPositionHolder();
        if (links != null && this.isCreateLinks()) {
            String[] proposalTypes;
            ITrackedNodePosition dataTypeTracker = this.getFactory().getRewrite().track((ASTNode)genericFromRadioButtonGroupType);
            links.addLinkedPosition(dataTypeTracker, true, "RADIO_VALUE_TYPE");
            links.addLinkedPositionProposalsHierarchy("SUPER_TYPE", this.getFactory().getScoutApi().IRadioButton().fqn());
            for (String fqn : proposalTypes = PROPOSAL_RADIO_DATA_TYPES.toArray(new String[0])) {
                ITypeBinding typeBinding = this.getFactory().resolveTypeBinding(fqn);
                if (typeBinding == null) continue;
                links.addLinkedPositionProposal("RADIO_VALUE_TYPE", typeBinding);
            }
        }
        return this;
    }

    protected String parseValueTypeTypeFromGroup() {
        org.eclipse.jdt.core.IType typeBinding = (org.eclipse.jdt.core.IType)Ensure.notNull((Object)AstUtils.getTypeBinding((AbstractTypeDeclaration)this.getDeclaringType()));
        IType scoutType = this.getFactory().getScoutElementProvider().toScoutType(typeBinding);
        IScoutInterfaceApi.IValueField iValueField = this.getFactory().getScoutApi().IValueField();
        return scoutType.resolveTypeParamValue(iValueField.valueTypeParamIndex(), iValueField.fqn()).flatMap(Stream::findFirst).map(IType::name).orElse(Object.class.getName());
    }

    protected void addGetConfiguredRadioValue(String valueTypeFqn) {
        AST ast = this.getFactory().getAst();
        Expression initValue = this.getFactory().newDefaultValueExpression(valueTypeFqn, false);
        ReturnStatement returnStatement = ast.newReturnStatement();
        returnStatement.setExpression(initValue);
        Block body = ast.newBlock();
        body.statements().add(returnStatement);
        Type simpleDataType = this.getFactory().newTypeReference(valueTypeFqn);
        ((AstMethodBuilder)((AbstractAstBuilder)((AstMethodBuilder)((AstMethodBuilder)((AstMethodBuilder)this.getFactory().newMethod(this.getFactory().getScoutApi().AbstractRadioButton().getConfiguredRadioValueMethodName()).withModifiers(Modifier.ModifierKeyword.PROTECTED_KEYWORD)).withOverride(true)).withReturnType(simpleDataType)).withBody(body)).in(this.get())).insert();
        ILinkedPositionHolder links = this.getFactory().getLinkedPositionHolder();
        if (links != null && this.isCreateLinks()) {
            links.addLinkedPosition(this.getFactory().getRewrite().track((ASTNode)simpleDataType), false, "RADIO_VALUE_TYPE");
            links.addLinkedPosition(this.getFactory().getRewrite().track((ASTNode)initValue), true, "RADIO_VALUE");
        }
    }

    static {
        PROPOSAL_RADIO_DATA_TYPES.add("java.lang.Long");
        PROPOSAL_RADIO_DATA_TYPES.add("java.lang.Boolean");
        PROPOSAL_RADIO_DATA_TYPES.add(BigDecimal.class.getName());
    }
}

