/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.environment;

import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.scout.sdk.core.builder.BuilderContext;
import org.eclipse.scout.sdk.core.builder.IBuilderContext;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.builder.MemorySourceBuilder;
import org.eclipse.scout.sdk.core.builder.java.JavaBuilderContext;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.CompilationUnitInfoWithClasspath;
import org.eclipse.scout.sdk.core.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.spi.ClasspathSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaEnvironmentSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.s.environment.AbstractEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IFuture;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.environment.SdkFuture;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.environment.AbstractJob;
import org.eclipse.scout.sdk.s2e.environment.CompilationUnitWriteOperation;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.environment.IResourceWriteOperation;
import org.eclipse.scout.sdk.s2e.environment.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.environment.OperationJob;
import org.eclipse.scout.sdk.s2e.environment.ResourceWriteOperation;
import org.eclipse.scout.sdk.s2e.environment.WorkingCopyManager;
import org.eclipse.scout.sdk.s2e.environment.model.ClasspathWithJdt;
import org.eclipse.scout.sdk.s2e.environment.model.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class EclipseEnvironment
extends AbstractEnvironment
implements AutoCloseable {
    private final Map<IJavaProject, JavaEnvironmentWithJdt> m_envs = new ConcurrentHashMap<IJavaProject, JavaEnvironmentWithJdt>();

    protected EclipseEnvironment() {
    }

    protected StringBuilder runGenerator(ISourceGenerator<ISourceBuilder<?>> generator, IJavaEnvironment context, Path targetPath) {
        return EclipseEnvironment.doCreateResource(generator, this.jdtJavaProjectOf(context), targetPath, context);
    }

    protected IFuture<Void> doWriteResource(CharSequence content, Path filePath, IProgress progress, boolean sync) {
        ResourceWriteOperation writeFile = new ResourceWriteOperation(this.pathToWorkspaceFile(filePath), content);
        return this.doRunResourceTask(writeFile, null, EclipseEnvironment.toScoutProgress(progress), sync);
    }

    protected IFuture<org.eclipse.scout.sdk.core.model.api.IType> doWriteCompilationUnit(CharSequence source, CompilationUnitInfoWithClasspath cuInfo, IProgress progress, boolean sync) {
        IClasspathEntry sourceFolder = cuInfo.classpathEntry();
        IPackageFragmentRoot packageFragmentRoot = ((ClasspathWithJdt)sourceFolder.unwrap()).getRoot();
        CompilationUnitWriteOperation writeIcu = new CompilationUnitWriteOperation(packageFragmentRoot, cuInfo.packageName(), cuInfo.fileName(), source);
        return this.doRunResourceTask(writeIcu, () -> this.registerCompilationUnit(writeIcu.getFormattedSource(), cuInfo), EclipseEnvironment.toScoutProgress(progress), sync);
    }

    protected IJavaProject jdtJavaProjectOf(IJavaEnvironment env) {
        return ((JavaEnvironmentWithJdt)env.unwrap()).javaProject();
    }

    protected StringBuilder doCreateResource(ISourceGenerator<ISourceBuilder<?>> generator, Path filePath) {
        IJavaProject javaProject = this.findJavaProject(filePath).orElseThrow(() -> Ensure.newFail((CharSequence)"Cannot find a Java project for path '{}'.", (Object[])new Object[]{filePath}));
        return EclipseEnvironment.doCreateResource(generator, javaProject, filePath, this.toScoutJavaEnvironment(javaProject));
    }

    protected static StringBuilder doCreateResource(ISourceGenerator<ISourceBuilder<?>> generator, IJavaProject javaProject, Path targetPath, IJavaEnvironment je) {
        BuilderContext ctx = EclipseEnvironment.createBuilderContextFor(javaProject, targetPath);
        MemorySourceBuilder builder = MemorySourceBuilder.create((IBuilderContext)new JavaBuilderContext((IBuilderContext)ctx, je));
        ((ISourceGenerator)Ensure.notNull(generator)).generate((ISourceBuilder)builder);
        return builder.source();
    }

    protected IFile pathToWorkspaceFile(Path filePath) {
        URI uri = ((Path)Ensure.notNull((Object)filePath)).toUri();
        return S2eUtils.findFileInWorkspace(uri).orElseThrow(() -> Ensure.newFail((CharSequence)"Could not find of workspace files for URI '{}'.", (Object[])new Object[]{uri}));
    }

    protected static BuilderContext createBuilderContextFor(IJavaProject javaProject, Path targetPath) {
        return new BuilderContext(Util.getLineSeparator(null, (IJavaProject)javaProject), S2eUtils.propertyMap(javaProject, targetPath));
    }

    protected <T> IFuture<T> doRunResourceTask(IResourceWriteOperation task, Supplier<T> resultExtractor, EclipseProgress progress, boolean syncRun) {
        Ensure.notNull((Object)task);
        Ensure.notNull((Object)progress);
        IResource rule = task.getAffectedResource();
        if (syncRun && EclipseEnvironment.isCurrentContextContaining((ISchedulingRule)rule)) {
            return this.doRunSync(task, resultExtractor, progress);
        }
        return this.doRunAsync(task, (ISchedulingRule)rule, resultExtractor);
    }

    protected <T> IFuture<T> doRunSync(Consumer<? super EclipseProgress> task, Supplier<T> resultExtractor, EclipseProgress progress) {
        RuntimeException t = null;
        try {
            task.accept(progress);
        }
        catch (RuntimeException e) {
            t = e;
        }
        return SdkFuture.completed(resultExtractor, (Throwable)t);
    }

    protected <T> IFuture<T> doRunAsync(final Consumer<? super EclipseProgress> operation, ISchedulingRule rule, Supplier<T> resultExtractor) {
        final IWorkingCopyManager workingCopyManager = WorkingCopyManager.currentWorkingCopyManager();
        AbstractJob job = new AbstractJob(OperationJob.getJobName(operation)){

            @Override
            protected void execute(IProgressMonitor monitor) {
                WorkingCopyManager.runWithWorkingCopyManager(() -> operation.accept(EclipseEnvironment.toScoutProgress(monitor)), workingCopyManager);
            }
        };
        job.setRule(rule);
        return job.scheduleWithFuture(0L, TimeUnit.MILLISECONDS, resultExtractor);
    }

    protected static boolean isCurrentContextContaining(ISchedulingRule rule) {
        if (rule == null) {
            return false;
        }
        ISchedulingRule currentRule = Job.getJobManager().currentRule();
        if (currentRule == null) {
            return false;
        }
        return currentRule.contains(rule);
    }

    public Optional<IJavaEnvironment> findJavaEnvironment(Path root) {
        return this.findJavaProject(root).map(this::toScoutJavaEnvironment);
    }

    public Path rootOfJavaEnvironment(IJavaEnvironment environment) {
        JavaEnvironmentWithJdt javaEnv = (JavaEnvironmentWithJdt)((IJavaEnvironment)Ensure.notNull((Object)environment)).unwrap();
        return javaEnv.javaProject().getProject().getLocation().toFile().toPath();
    }

    public Optional<IJavaProject> findJavaProject(Path root) {
        if (root == null) {
            return Optional.empty();
        }
        try {
            IJavaProject[] javaProjects;
            for (IJavaProject jp : javaProjects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects()) {
                IPath location = jp.getProject().getLocation();
                if (location == null || !root.startsWith(location.toFile().toPath())) continue;
                return Optional.of(jp);
            }
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
        return Optional.empty();
    }

    public Stream<org.eclipse.scout.sdk.core.model.api.IType> findType(String fqn) {
        Ensure.notBlank((CharSequence)fqn);
        return JdtUtils.resolveJdtTypes(fqn).stream().map(this::toScoutType);
    }

    protected JavaEnvironmentWithJdt getOrCreateEnv(IJavaProject jdtProject) {
        return this.m_envs.computeIfAbsent(jdtProject, this::createNewJavaEnvironmentFor);
    }

    protected JavaEnvironmentWithJdt createNewJavaEnvironmentFor(IJavaProject jdtProject) {
        return (JavaEnvironmentWithJdt)this.initNewJavaEnvironment((JavaEnvironmentSpi)new JavaEnvironmentWithJdt(jdtProject));
    }

    @Override
    public void close() {
        Iterator<JavaEnvironmentWithJdt> iterator = this.m_envs.values().iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().close();
            }
            catch (RuntimeException e) {
                SdkLog.warning((CharSequence)"Unable to close java environment.", (Object[])new Object[]{e});
            }
            iterator.remove();
        }
    }

    public IJavaEnvironment toScoutJavaEnvironment(IJavaProject jdtProject) {
        return this.getOrCreateEnv((IJavaProject)Ensure.notNull((Object)jdtProject)).wrap();
    }

    public org.eclipse.scout.sdk.core.model.api.IType toScoutType(IType jdtType) {
        if (!JdtUtils.exists((IJavaElement)jdtType)) {
            return null;
        }
        return EclipseEnvironment.toScoutType(jdtType, (JavaEnvironmentSpi)this.getOrCreateEnv(jdtType.getJavaProject()));
    }

    protected static org.eclipse.scout.sdk.core.model.api.IType toScoutType(IType jdtType, JavaEnvironmentSpi env) {
        if (jdtType == null || env == null) {
            return null;
        }
        TypeSpi typeSpi = env.findType(jdtType.getFullyQualifiedName());
        if (typeSpi == null) {
            return null;
        }
        return typeSpi.wrap();
    }

    public IClasspathEntry toScoutSourceFolder(IPackageFragmentRoot root) {
        if (!JdtUtils.exists((IJavaElement)root)) {
            return null;
        }
        ClasspathSpi classpath = this.getOrCreateEnv(root.getJavaProject()).getClasspathFor(root);
        if (classpath == null) {
            return null;
        }
        return classpath.wrap();
    }

    public static EclipseProgress toScoutProgress(IProgress progress) {
        if (progress == null) {
            return EclipseEnvironment.toScoutProgress((IProgressMonitor)null);
        }
        if (progress instanceof EclipseProgress) {
            return (EclipseProgress)progress;
        }
        throw Ensure.newFail((CharSequence)"Not in an Eclipse context: {}", (Object[])new Object[]{progress.getClass().getName(), new Exception("origin")});
    }

    public static EclipseProgress toScoutProgress(IProgressMonitor m) {
        return new EclipseProgress(m);
    }

    public static EclipseEnvironment narrow(IEnvironment env) {
        if (env instanceof EclipseEnvironment) {
            return (EclipseEnvironment)env;
        }
        throw Ensure.newFail((CharSequence)"Not an Eclipse environment: {}", (Object[])new Object[]{env.getClass().getName(), new Exception("origin")});
    }

    public static IType toJdtType(org.eclipse.scout.sdk.core.model.api.IType scoutType) {
        IJavaProject javaProject = ((JavaEnvironmentWithJdt)((org.eclipse.scout.sdk.core.model.api.IType)Ensure.notNull((Object)scoutType)).javaEnvironment().unwrap()).javaProject();
        try {
            return javaProject.findType(scoutType.name().replace('$', '.'), (IProgressMonitor)null);
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
    }

    protected Collection<? extends JavaEnvironmentSpi> javaEnvironments() {
        return this.m_envs.values();
    }

    public static IFuture<Void> runInEclipseEnvironment(BiConsumer<? super EclipseEnvironment, ? super EclipseProgress> task) {
        return EclipseEnvironment.runInEclipseEnvironment(task, null);
    }

    public static IFuture<Void> runInEclipseEnvironment(BiConsumer<? super EclipseEnvironment, ? super EclipseProgress> task, ISchedulingRule rule) {
        return EclipseEnvironment.callInEclipseEnvironment((e, p) -> {
            task.accept((EclipseEnvironment)e, (EclipseProgress)p);
            return null;
        }, rule, OperationJob.getJobName(task));
    }

    public static <T> IFuture<T> callInEclipseEnvironment(BiFunction<? super EclipseEnvironment, ? super EclipseProgress, T> task) {
        return EclipseEnvironment.callInEclipseEnvironment(task, null);
    }

    public static <T> T callInEclipseEnvironmentSync(BiFunction<? super EclipseEnvironment, ? super EclipseProgress, T> task, IProgressMonitor monitor) {
        Ensure.notNull((Object)monitor);
        try (EclipseEnvironment eclipseEnvironment = new EclipseEnvironment();){
            T t = task.apply(eclipseEnvironment, EclipseEnvironment.toScoutProgress(monitor));
            return t;
        }
    }

    public static <T> IFuture<T> callInEclipseEnvironment(BiFunction<? super EclipseEnvironment, ? super EclipseProgress, T> task, ISchedulingRule rule) {
        return EclipseEnvironment.callInEclipseEnvironment(task, rule, OperationJob.getJobName(task));
    }

    public static <T> IFuture<T> callInEclipseEnvironment(BiFunction<? super EclipseEnvironment, ? super EclipseProgress, T> task, ISchedulingRule rule, String jobName) {
        AtomicReference result = new AtomicReference();
        OperationJob job = new OperationJob((env, progress) -> result.set(task.apply((EclipseEnvironment)env, (EclipseProgress)progress)), jobName);
        job.setRule(rule);
        return job.scheduleWithFuture(0L, TimeUnit.MILLISECONDS, result::get);
    }

    public static EclipseEnvironment createUnsafe(Consumer<EclipseEnvironment> registerCloseCallback) {
        EclipseEnvironment eclipseEnvironment = new EclipseEnvironment();
        ((Consumer)Ensure.notNull(registerCloseCallback)).accept(eclipseEnvironment);
        return eclipseEnvironment;
    }
}

