/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.s2e.ui.internal.template.AsyncProposalPosition;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ICompletionProposalProvider;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ILinkedAsyncProposalListener;
import org.eclipse.scout.sdk.s2e.ui.internal.template.LinkedPositionProposalImpl;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public final class LinkedAsyncProposalModelPresenter {
    private LinkedAsyncProposalModelPresenter() {
    }

    public static void enterLinkedMode(ITextViewer viewer, IEditorPart editor, boolean switchedEditor, LinkedProposalModel linkedProposalModel) throws BadLocationException {
        IDocument document = viewer.getDocument();
        AtomicReference<LinkedModeUI> linkedModeUiRef = new AtomicReference<LinkedModeUI>();
        LinkedModeModel model = LinkedAsyncProposalModelPresenter.createLinkedModeModel(linkedProposalModel, document, linkedModeUiRef);
        model.forceInstall();
        if (editor instanceof JavaEditor) {
            model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer((JavaEditor)editor));
        }
        LinkedModeUI ui = LinkedAsyncProposalModelPresenter.createLinkedModeUi(viewer, switchedEditor, model, linkedProposalModel);
        linkedModeUiRef.compareAndSet(null, ui);
        ui.enter();
        IRegion region = ui.getSelectedRegion();
        viewer.setSelectedRange(region.getOffset(), region.getLength());
        viewer.revealRange(region.getOffset(), region.getLength());
    }

    static LinkedModeUI createLinkedModeUi(ITextViewer viewer, boolean switchedEditor, LinkedModeModel model, LinkedProposalModel linkedProposalModel) throws BadLocationException {
        int cursorPosition;
        EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
        LinkedProposalPositionGroupCore.PositionInformation endPosition = linkedProposalModel.getEndPosition();
        int offset = -1;
        if (endPosition != null) {
            offset = endPosition.getOffset();
        }
        if (offset != -1 && endPosition != null) {
            ui.setExitPosition(viewer, offset + endPosition.getLength(), 0, Integer.MAX_VALUE);
        } else if (!switchedEditor && (cursorPosition = viewer.getSelectedRange().x) != 0) {
            ui.setExitPosition(viewer, cursorPosition, 0, Integer.MAX_VALUE);
        }
        ui.setExitPolicy((LinkedModeUI.IExitPolicy)new LinkedModeExitPolicy());
        return ui;
    }

    static LinkedModeModel createLinkedModeModel(LinkedProposalModel linkedProposalModel, IDocument document, AtomicReference<LinkedModeUI> linkedModeUiRef) throws BadLocationException {
        Iterator iterator = linkedProposalModel.getPositionGroupIterator();
        LinkedModeModel model = new LinkedModeModel();
        while (iterator.hasNext()) {
            LinkedProposalPositionGroup curr = (LinkedProposalPositionGroup)iterator.next();
            LinkedProposalPositionGroupCore.PositionInformation[] positions = curr.getPositions();
            if (positions.length <= 0) continue;
            LinkedPositionGroup group = LinkedAsyncProposalModelPresenter.createGroup(document, model, curr, linkedModeUiRef);
            model.addGroup(group);
        }
        return model;
    }

    static LinkedPositionGroup createGroup(IDocument document, LinkedModeModel model, LinkedProposalPositionGroup propPositionGroup, AtomicReference<LinkedModeUI> linkedModeUiRef) throws BadLocationException {
        if (propPositionGroup instanceof ICompletionProposalProvider) {
            return LinkedAsyncProposalModelPresenter.createAsyncGroup(document, model, (ICompletionProposalProvider)propPositionGroup, linkedModeUiRef);
        }
        LinkedPositionGroup group = new LinkedPositionGroup();
        LinkedProposalPositionGroupCore.PositionInformation[] positions = propPositionGroup.getPositions();
        LinkedProposalPositionGroup.Proposal[] linkedModeProposals = propPositionGroup.getProposals();
        if (linkedModeProposals.length <= 1) {
            LinkedProposalPositionGroupCore.PositionInformation[] positionInformationArray = positions;
            int n = positions.length;
            int n2 = 0;
            while (n2 < n) {
                LinkedProposalPositionGroupCore.PositionInformation pos = positionInformationArray[n2];
                if (pos.getOffset() != -1) {
                    group.addPosition(new LinkedPosition(document, pos.getOffset(), pos.getLength(), pos.getSequenceRank()));
                }
                ++n2;
            }
        } else {
            LinkedPositionProposalImpl[] proposalImpls = new LinkedPositionProposalImpl[linkedModeProposals.length];
            int i = 0;
            while (i < linkedModeProposals.length) {
                proposalImpls[i] = new LinkedPositionProposalImpl(linkedModeProposals[i], model);
                ++i;
            }
            LinkedProposalPositionGroupCore.PositionInformation[] positionInformationArray = positions;
            int n = positions.length;
            int n3 = 0;
            while (n3 < n) {
                LinkedProposalPositionGroupCore.PositionInformation pos = positionInformationArray[n3];
                if (pos.getOffset() != -1) {
                    group.addPosition((LinkedPosition)new ProposalPosition(document, pos.getOffset(), pos.getLength(), pos.getSequenceRank(), (ICompletionProposal[])proposalImpls));
                }
                ++n3;
            }
        }
        return group;
    }

    static LinkedPositionGroup createAsyncGroup(IDocument document, LinkedModeModel model, ICompletionProposalProvider proposalProvider, AtomicReference<LinkedModeUI> linkedModeUiRef) throws BadLocationException {
        LinkedProposalPositionGroupCore.PositionInformation[] positions = proposalProvider.getPositions();
        LinkedPositionGroup group = new LinkedPositionGroup();
        Display display = Display.getCurrent();
        P_ProposalListener listener = new P_ProposalListener(display, linkedModeUiRef);
        LinkedProposalPositionGroupCore.PositionInformation[] positionInformationArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            LinkedProposalPositionGroupCore.PositionInformation pos = positionInformationArray[n2];
            if (pos.getOffset() != -1) {
                if (display != null) {
                    proposalProvider.addListener(listener);
                }
                group.addPosition((LinkedPosition)new AsyncProposalPosition(document, pos.getOffset(), pos.getLength(), pos.getSequenceRank(), proposalProvider, model));
            }
            ++n2;
        }
        return group;
    }

    private static final class LinkedModeExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private LinkedModeExitPolicy() {
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (event.character == '=') {
                return new LinkedModeUI.ExitFlags(1, true);
            }
            return null;
        }
    }

    protected static class P_ProposalListener
    implements ILinkedAsyncProposalListener {
        private final Display m_display;
        private final AtomicReference<LinkedModeUI> m_linkedModeUiRef;

        protected P_ProposalListener(Display display, AtomicReference<LinkedModeUI> linkedModeUiRef) {
            this.m_display = display;
            this.m_linkedModeUiRef = linkedModeUiRef;
        }

        @Override
        public void loaded() {
            this.m_display.asyncExec(this::triggerContentAssist);
        }

        private void triggerContentAssist() {
            LinkedModeUI linkedModeUi = this.m_linkedModeUiRef.get();
            if (linkedModeUi == null) {
                return;
            }
            try {
                Method m = LinkedModeUI.class.getDeclaredMethod("triggerContentAssist", new Class[0]);
                m.setAccessible(true);
                m.invoke((Object)linkedModeUi, new Object[0]);
            }
            catch (Exception t) {
                SdkLog.warning((Object[])new Object[]{t});
            }
        }
    }
}

