/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.proposal;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.TranslationStoreStack;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.proposal.TranslationNewProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.proposal.TranslationProposal;

public class TranslationProposalComputer
implements IJavaCompletionProposalComputer {
    private static final Pattern PATTERN = Pattern.compile("([A-Za-z0-9_\\-]*)\\.get\\(\"([a-zA-Z0-9_\\-]*)");

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (!(context instanceof JavaContentAssistInvocationContext)) {
            return Collections.emptyList();
        }
        JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
        return TranslationProposalComputer.computeProposals(javaContext);
    }

    protected static List<ICompletionProposal> computeProposals(JavaContentAssistInvocationContext context) {
        int offset = context.getInvocationOffset();
        IDocument doc = context.getDocument();
        if (doc == null || offset > doc.getLength()) {
            return Collections.emptyList();
        }
        try {
            IRegion lineInfo = doc.getLineInformationOfOffset(offset);
            String linePart = doc.get(lineInfo.getOffset(), lineInfo.getLength());
            Matcher m = PATTERN.matcher(linePart);
            int cursorPosInLine = offset - lineInfo.getOffset();
            int matchingStart = -1;
            while (m.find()) {
                int match = m.start(2);
                if (match > cursorPosInLine || match <= matchingStart) continue;
                matchingStart = match;
            }
            if (matchingStart >= 0) {
                String prefix = linePart.substring(matchingStart, offset - lineInfo.getOffset());
                Path path = context.getCompilationUnit().getResource().getLocation().toFile().toPath();
                return (List)EclipseEnvironment.callInEclipseEnvironment((env, progress) -> TranslationStoreStack.create((Path)path, (IEnvironment)env, (IProgress)progress).map(stack -> TranslationProposalComputer.collectProposals(stack, prefix, offset)).orElseGet(Collections::emptyList)).result();
            }
        }
        catch (RuntimeException | BadLocationException e) {
            SdkLog.warning((String)"Could not compute translation proposals.", (Object[])new Object[]{e});
        }
        return Collections.emptyList();
    }

    protected static List<ICompletionProposal> collectProposals(TranslationStoreStack stack, String prefix, int offset) {
        List<ICompletionProposal> result = stack.allWithPrefix(prefix).map(t -> new TranslationProposal((ITranslation)t, prefix, offset)).collect(Collectors.toList());
        if (stack.isEditable()) {
            result.add((ICompletionProposal)new TranslationNewProposal(stack, prefix, offset));
        }
        return result;
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionStarted() {
    }

    public void sessionEnded() {
    }
}

