/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.net;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.net.NetActivator;
import org.eclipse.scout.net.internal.TTLCache;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

@Deprecated
public final class EclipseProxySelector
extends ProxySelector {
    private AtomicBoolean m_initialized = new AtomicBoolean();
    private AtomicBoolean m_initializeInProgress = new AtomicBoolean();
    private boolean m_cacheEnabled = true;
    private Object m_cacheLock = new Object();
    private TTLCache<URI, List<Proxy>> m_cache = new TTLCache(300000L);

    public EclipseProxySelector() {
        try {
            String ttlText = NetActivator.getDefault().getBundle().getBundleContext().getProperty("org.eclipse.scout.net.cache");
            if (ttlText != null) {
                long ttl = Long.parseLong(ttlText);
                if (ttl > 0L) {
                    this.m_cache.setTTL(ttl);
                } else {
                    this.m_cacheEnabled = false;
                }
            }
        }
        catch (Throwable throwable) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Proxy> select(URI uri) {
        ArrayList<Proxy> list;
        if (this.m_cacheEnabled) {
            Object object = this.m_cacheLock;
            synchronized (object) {
                list = this.m_cache.get(uri);
                if (list != null) {
                    return list;
                }
            }
        }
        list = new ArrayList();
        IProxyData[] datas = this.reentrantSelectImpl(uri);
        if (datas != null) {
            IProxyData[] iProxyDataArray = datas;
            int n = datas.length;
            int n2 = 0;
            while (n2 < n) {
                IProxyData data = iProxyDataArray[n2];
                Proxy.Type javaNetType = null;
                if (data.getType().equals("SOCKS")) {
                    javaNetType = Proxy.Type.SOCKS;
                } else if (data.getType().equals("HTTP")) {
                    javaNetType = Proxy.Type.HTTP;
                } else if (data.getType().equals("HTTPS")) {
                    javaNetType = Proxy.Type.HTTP;
                }
                if (javaNetType != null) {
                    Proxy javaNetProxy = new Proxy(javaNetType, InetSocketAddress.createUnresolved(data.getHost(), data.getPort()));
                    list.add(javaNetProxy);
                }
                ++n2;
            }
        }
        if (list.size() == 0) {
            list.add(Proxy.NO_PROXY);
        }
        list = Collections.unmodifiableList(list);
        if (this.m_cacheEnabled) {
            Object object = this.m_cacheLock;
            synchronized (object) {
                this.m_cache.put(uri, list);
            }
        }
        return list;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        NetActivator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.scout.net", "Failed connecting to proxy server " + sa, (Throwable)ioe));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IProxyData[] reentrantSelectImpl(URI uri) {
        AtomicBoolean atomicBoolean = this.m_initialized;
        synchronized (atomicBoolean) {
            if (!this.m_initialized.get() && !this.m_initializeInProgress.get()) {
                try {
                    this.m_initializeInProgress.set(true);
                    IProxyData[] iProxyDataArray = this.safeSelectImpl(uri);
                    return iProxyDataArray;
                }
                finally {
                    this.m_initialized.set(true);
                    this.m_initializeInProgress.set(false);
                }
            }
        }
        if (this.m_initialized.get()) {
            return this.safeSelectImpl(uri);
        }
        return new IProxyData[0];
    }

    private IProxyData[] safeSelectImpl(URI uri) {
        BundleContext context = NetActivator.getDefault().getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(IProxyService.class.getName());
        if (ref != null) {
            try {
                IProxyService service = (IProxyService)context.getService(ref);
                Version frameworkVersion = new Version(NetActivator.getDefault().getBundle().getBundleContext().getProperty("osgi.framework.version"));
                if (frameworkVersion.getMajor() == 3 && frameworkVersion.getMinor() <= 4) {
                    IProxyData[] iProxyDataArray = new IProxyData[]{};
                    return iProxyDataArray;
                }
                Method method = IProxyService.class.getMethod("select", URI.class);
                IProxyData[] iProxyDataArray = (IProxyData[])method.invoke((Object)service, uri);
                return iProxyDataArray;
            }
            finally {
                context.ungetService(ref);
            }
        }
        return new IProxyData[0];
    }
}

