/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.rulers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.AccessibleHandleProvider;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.internal.ui.rulers.DragGuidePolicy;
import org.eclipse.gef.internal.ui.rulers.GuideFigure;
import org.eclipse.gef.internal.ui.rulers.RulerEditPart;
import org.eclipse.gef.rulers.RulerChangeListener;
import org.eclipse.gef.rulers.RulerProvider;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Cursor;

public class GuideEditPart
extends AbstractGraphicalEditPart {
    public static final int MIN_DISTANCE_BW_GUIDES = 5;
    public static final int DELETE_THRESHOLD = 20;
    private AccessibleEditPart accPart;
    private GuideLineFigure guideLineFig;
    private Cursor cursor = null;
    private ZoomListener zoomListener = new ZoomListener(){

        public void zoomChanged(double zoom) {
            GuideEditPart.this.handleZoomChanged();
        }
    };
    private RulerChangeListener listener = new RulerChangeListener.Stub(){

        public void notifyGuideMoved(Object guide) {
            if (GuideEditPart.this.getModel() == guide) {
                GuideEditPart.this.handleGuideMoved();
            }
        }

        public void notifyPartAttachmentChanged(Object part, Object guide) {
            if (GuideEditPart.this.getModel() == guide) {
                GuideEditPart.this.handlePartAttachmentChanged(part);
            }
        }
    };

    public GuideEditPart(Object model) {
        this.setModel(model);
    }

    public void activate() {
        super.activate();
        this.getRulerProvider().addRulerChangeListener(this.listener);
        if (this.getZoomManager() != null) {
            this.getZoomManager().addZoomListener(this.zoomListener);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", new GuideSelectionPolicy());
        this.installEditPolicy("PrimaryDrag Policy", new DragGuidePolicy());
    }

    protected IFigure createFigure() {
        this.guideLineFig = this.createGuideLineFigure();
        this.getGuideLayer().add(this.getGuideLineFigure());
        this.getGuideLayer().setConstraint(this.getGuideLineFigure(), (Object)new Boolean(this.isHorizontal()));
        return new GuideFigure(this.isHorizontal());
    }

    protected GuideLineFigure createGuideLineFigure() {
        return new GuideLineFigure();
    }

    public void deactivate() {
        if (this.getZoomManager() != null) {
            this.getZoomManager().removeZoomListener(this.zoomListener);
        }
        this.getRulerProvider().removeRulerChangeListener(this.listener);
        if (this.getGuideLineFigure().getParent() != null) {
            this.getGuideLineFigure().getParent().remove(this.getGuideLineFigure());
        }
        super.deactivate();
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accPart == null) {
            this.accPart = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

                public void getDescription(AccessibleEvent e) {
                    if (GuideEditPart.this.getRulerProvider() != null) {
                        GuideEditPart.this.getRulerProvider().getAccGuideDescription(e, GuideEditPart.this.getModel());
                    }
                }

                public void getName(AccessibleEvent e) {
                    if (GuideEditPart.this.getRulerProvider() != null) {
                        GuideEditPart.this.getRulerProvider().getAccGuideName(e, GuideEditPart.this.getModel());
                    }
                }

                public void getValue(AccessibleControlEvent e) {
                    if (GuideEditPart.this.getRulerProvider() != null) {
                        GuideEditPart.this.getRulerProvider().getAccGuideValue(e, GuideEditPart.this.getModel());
                    }
                }
            };
        }
        return this.accPart;
    }

    public Object getAdapter(Class key) {
        if (key == AccessibleHandleProvider.class) {
            return new AccessibleHandleProvider(){

                public List getAccessibleHandleLocations() {
                    ArrayList<Point> result = new ArrayList<Point>();
                    Point pt = GuideEditPart.this.getFigure().getBounds().getCenter();
                    GuideEditPart.this.getFigure().translateToAbsolute((Translatable)pt);
                    result.add(pt);
                    return result;
                }
            };
        }
        return super.getAdapter(key);
    }

    public Cursor getCurrentCursor() {
        if (this.cursor == null) {
            return this.getFigure().getCursor();
        }
        return this.cursor;
    }

    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTracker(this){

            protected Cursor calculateCursor() {
                if (this.isInState(8)) {
                    return Cursors.NO;
                }
                return GuideEditPart.this.getCurrentCursor();
            }

            protected boolean isMove() {
                return true;
            }
        };
    }

    public IFigure getGuideLayer() {
        return this.getRulerEditPart().getGuideLayer();
    }

    public IFigure getGuideLineFigure() {
        return this.guideLineFig;
    }

    public RulerEditPart getRulerEditPart() {
        return (RulerEditPart)this.getParent();
    }

    public RulerProvider getRulerProvider() {
        return this.getRulerEditPart().getRulerProvider();
    }

    public int getZoomedPosition() {
        double position = this.getRulerProvider().getGuidePosition(this.getModel());
        if (this.getZoomManager() != null) {
            position = Math.round(position * this.getZoomManager().getZoom());
        }
        return (int)position;
    }

    public ZoomManager getZoomManager() {
        return this.getRulerEditPart().getZoomManager();
    }

    protected void handleGuideMoved() {
        this.refreshVisuals();
    }

    protected void handlePartAttachmentChanged(Object part) {
    }

    protected void handleZoomChanged() {
        this.refreshVisuals();
    }

    public boolean isHorizontal() {
        return !this.getRulerEditPart().isHorizontal();
    }

    protected void refreshVisuals() {
        this.updateLocationOfFigures(this.getZoomedPosition());
    }

    public void removeNotify() {
        GraphicalEditPart nextSelection = null;
        if (this.getParent().isActive()) {
            int thisPos = this.getRulerProvider().getGuidePosition(this.getModel());
            if (this.getSelected() != 0 || this.hasFocus()) {
                List siblings = this.getParent().getChildren();
                int minDistance = -1;
                int i = 0;
                while (i < siblings.size()) {
                    GuideEditPart guide = (GuideEditPart)siblings.get(i);
                    if (guide != this) {
                        int posDiff = Math.abs(thisPos - this.getRulerProvider().getGuidePosition(guide.getModel()));
                        if (minDistance == -1 || posDiff < minDistance) {
                            minDistance = posDiff;
                            nextSelection = guide;
                        }
                    }
                    ++i;
                }
                if (nextSelection == null) {
                    nextSelection = (GraphicalEditPart)this.getParent();
                }
            }
        }
        super.removeNotify();
        if (nextSelection != null) {
            this.getViewer().select(nextSelection);
        }
    }

    public void setCurrentCursor(Cursor c) {
        this.cursor = c;
    }

    public void updateLocationOfFigures(int position) {
        this.getRulerEditPart().setLayoutConstraint(this, this.getFigure(), new Integer(position));
        Point guideFeedbackLocation = this.getGuideLineFigure().getBounds().getLocation();
        if (this.isHorizontal()) {
            guideFeedbackLocation.y = position;
        } else {
            guideFeedbackLocation.x = position;
        }
        this.getGuideLineFigure().setLocation(guideFeedbackLocation);
        this.getGuideLineFigure().revalidate();
    }

    public static class GuideLineFigure
    extends Figure {
        public GuideLineFigure() {
            this.setPreferredSize(1, 1);
        }

        protected void paintFigure(Graphics g) {
            g.setLineStyle(3);
            g.setXORMode(true);
            g.setForegroundColor(ColorConstants.darkGray);
            if (this.bounds.width > this.bounds.height) {
                g.drawLine(this.bounds.x, this.bounds.y, this.bounds.right(), this.bounds.y);
                g.drawLine(this.bounds.x + 2, this.bounds.y, this.bounds.right(), this.bounds.y);
            } else {
                g.drawLine(this.bounds.x, this.bounds.y, this.bounds.x, this.bounds.bottom());
                g.drawLine(this.bounds.x, this.bounds.y + 2, this.bounds.x, this.bounds.bottom());
            }
        }
    }

    public static class GuideSelectionPolicy
    extends SelectionEditPolicy {
        protected void hideFocus() {
            ((GuideFigure)this.getHostFigure()).setDrawFocus(false);
        }

        protected void hideSelection() {
            ((GuideFigure)this.getHostFigure()).setDrawFocus(false);
        }

        protected void showFocus() {
            ((GuideFigure)this.getHostFigure()).setDrawFocus(true);
        }

        protected void showSelection() {
            ((GuideFigure)this.getHostFigure()).setDrawFocus(true);
        }
    }
}

