/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.servlet.internal.servlet;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;

public class HttpServletResponseWrapperImpl
extends HttpServletResponseWrapper {
    private int status = -1;
    private String message;
    private boolean completed;
    private InternalOutputStream outputStream;
    private InternalWriter writer;

    public HttpServletResponseWrapperImpl(HttpServletResponse response) {
        super(response);
    }

    public void sendError(int theStatus) {
        this.status = theStatus;
    }

    public void sendError(int theStatus, String theMessage) {
        this.status = theStatus;
        this.message = theMessage;
    }

    public String getMessage() {
        return this.message;
    }

    public int getStatus() {
        if (this.status == -1) {
            return super.getStatus();
        }
        return this.status;
    }

    public int getInternalStatus() {
        return this.status;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new InternalOutputStream(super.getOutputStream());
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new InternalWriter(super.getWriter());
        }
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        if (this.status != -1) {
            HttpServletResponse wrappedResponse = (HttpServletResponse)this.getResponse();
            wrappedResponse.sendError(this.status, this.getMessage());
        }
        super.flushBuffer();
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public static HttpServletResponseWrapperImpl findHttpRuntimeResponse(HttpServletResponse response) {
        while (response instanceof HttpServletResponseWrapper) {
            if (response instanceof HttpServletResponseWrapperImpl) {
                return (HttpServletResponseWrapperImpl)response;
            }
            response = (HttpServletResponse)((HttpServletResponseWrapper)response).getResponse();
        }
        return null;
    }

    private class InternalOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream originalOutputStream;

        public InternalOutputStream(ServletOutputStream originalOutputStream) {
            this.originalOutputStream = originalOutputStream;
        }

        public void close() throws IOException {
            this.originalOutputStream.close();
        }

        public void flush() throws IOException {
            if (HttpServletResponseWrapperImpl.this.getInternalStatus() != -1) {
                HttpServletResponse wrappedResponse = (HttpServletResponse)HttpServletResponseWrapperImpl.this.getResponse();
                wrappedResponse.sendError(HttpServletResponseWrapperImpl.this.getInternalStatus(), HttpServletResponseWrapperImpl.this.getMessage());
            }
            this.originalOutputStream.flush();
        }

        public boolean isReady() {
            return this.originalOutputStream.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.originalOutputStream.setWriteListener(writeListener);
        }

        public void write(int b) throws IOException {
            if (HttpServletResponseWrapperImpl.this.isCompleted()) {
                return;
            }
            this.originalOutputStream.write(b);
        }

        public void write(byte[] b) throws IOException {
            if (HttpServletResponseWrapperImpl.this.isCompleted()) {
                return;
            }
            this.originalOutputStream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (HttpServletResponseWrapperImpl.this.isCompleted()) {
                return;
            }
            this.originalOutputStream.write(b, off, len);
        }
    }

    private class InternalWriter
    extends PrintWriter {
        public InternalWriter(PrintWriter originalWriter) {
            super(originalWriter);
        }

        @Override
        public PrintWriter format(Locale l, String format, Object ... args) {
            if (!HttpServletResponseWrapperImpl.this.isCompleted()) {
                super.format(l, format, args);
            }
            return this;
        }

        @Override
        public PrintWriter format(String format, Object ... args) {
            if (!HttpServletResponseWrapperImpl.this.isCompleted()) {
                super.format(format, args);
            }
            return this;
        }

        @Override
        public void println() {
            if (HttpServletResponseWrapperImpl.this.isCompleted()) {
                return;
            }
            super.println();
        }

        @Override
        public void write(int c) {
            if (HttpServletResponseWrapperImpl.this.isCompleted()) {
                return;
            }
            super.write(c);
        }

        @Override
        public void write(char[] buf, int off, int len) {
            if (HttpServletResponseWrapperImpl.this.isCompleted()) {
                return;
            }
            super.write(buf, off, len);
        }

        @Override
        public void write(char[] buf) {
            if (HttpServletResponseWrapperImpl.this.isCompleted()) {
                return;
            }
            super.write(buf);
        }

        @Override
        public void write(String s, int off, int len) {
            if (HttpServletResponseWrapperImpl.this.isCompleted()) {
                return;
            }
            super.write(s, off, len);
        }

        @Override
        public void write(String s) {
            if (HttpServletResponseWrapperImpl.this.isCompleted()) {
                return;
            }
            super.write(s);
        }
    }
}

