/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.security.Permission;
import java.util.Dictionary;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.equinox.internal.cm.ConfigurationAdminImpl;
import org.eclipse.equinox.internal.cm.ConfigurationImpl;
import org.eclipse.equinox.internal.cm.ConfigurationStore;
import org.eclipse.equinox.internal.cm.EventDispatcher;
import org.eclipse.equinox.internal.cm.LogTracker;
import org.eclipse.equinox.internal.cm.ManagedServiceFactoryTracker;
import org.eclipse.equinox.internal.cm.ManagedServiceTracker;
import org.eclipse.equinox.internal.cm.PluginManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationPermission;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.Coordinator;
import org.osgi.service.coordinator.Participant;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigurationAdminFactory
implements ServiceFactory<ConfigurationAdmin>,
BundleListener {
    private static final Permission allConfigurationPermission = new ConfigurationPermission("*", "configure");
    private static final Permission allAttributePermission = new ConfigurationPermission("*", "attribute");
    private final EventDispatcher eventDispatcher;
    private final PluginManager pluginManager;
    private final LogTracker log;
    private final ManagedServiceTracker managedServiceTracker;
    private final ManagedServiceFactoryTracker managedServiceFactoryTracker;
    private final ConfigurationStore configurationStore;
    private final ServiceTracker<Coordinator, Coordinator> coordinationServiceTracker;

    public ConfigurationAdminFactory(BundleContext context, LogTracker log) {
        this.log = log;
        this.configurationStore = new ConfigurationStore(this, context);
        this.eventDispatcher = new EventDispatcher(context, log, this);
        this.pluginManager = new PluginManager(context);
        this.managedServiceTracker = new ManagedServiceTracker(this, this.configurationStore, context);
        this.managedServiceFactoryTracker = new ManagedServiceFactoryTracker(this, this.configurationStore, context);
        this.coordinationServiceTracker = new ServiceTracker(context, Coordinator.class, null);
    }

    void start() {
        this.coordinationServiceTracker.open();
        this.eventDispatcher.start();
        this.pluginManager.start();
        this.managedServiceTracker.open();
        this.managedServiceFactoryTracker.open();
    }

    void stop() {
        this.managedServiceTracker.close();
        this.managedServiceFactoryTracker.close();
        this.eventDispatcher.stop();
        this.pluginManager.stop();
        this.coordinationServiceTracker.close();
    }

    public ConfigurationAdmin getService(Bundle bundle, ServiceRegistration<ConfigurationAdmin> registration) {
        ServiceReference reference = registration.getReference();
        this.eventDispatcher.setServiceReference((ServiceReference<ConfigurationAdmin>)reference);
        return new ConfigurationAdminImpl(this, this.configurationStore, bundle);
    }

    public void ungetService(Bundle bundle, ServiceRegistration<ConfigurationAdmin> registration, ConfigurationAdmin service) {
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            this.configurationStore.unbindConfigurations(event.getBundle());
        }
    }

    public void checkConfigurePermission(String location, String forBundleLocation) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (!(sm == null || forBundleLocation != null && forBundleLocation.equals(location))) {
            if (location == null) {
                sm.checkPermission(allConfigurationPermission);
            } else {
                sm.checkPermission((Permission)new ConfigurationPermission(location, "configure"));
            }
        }
    }

    public boolean checkTargetPermission(String location, ServiceReference<?> ref) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            String forBundleLocation;
            Bundle b = ref.getBundle();
            if (location != null && b != null && !(forBundleLocation = ConfigurationAdminImpl.getLocation(b)).equals(location) && location != null) {
                return b.hasPermission((Object)new ConfigurationPermission(location, "target"));
            }
        }
        return true;
    }

    public void checkAttributePermission(String location) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (location == null) {
                sm.checkPermission(allAttributePermission);
            } else {
                sm.checkPermission((Permission)new ConfigurationPermission(location, "attribute"));
            }
        }
    }

    void warn(String message) {
        this.log.warn(message);
    }

    void error(String message) {
        this.log.error(message);
    }

    void error(String message, Throwable exception) {
        this.log.error(message, exception);
    }

    void dispatchEvent(int type, String factoryPid, String pid) {
        this.eventDispatcher.dispatchEvent(type, factoryPid, pid);
    }

    void notifyConfigurationUpdated(ConfigurationImpl config, boolean isFactory) {
        if (isFactory) {
            this.managedServiceFactoryTracker.notifyUpdated(config);
        } else {
            this.managedServiceTracker.notifyUpdated(config);
        }
    }

    void notifyConfigurationDeleted(ConfigurationImpl config, boolean isFactory) {
        if (isFactory) {
            this.managedServiceFactoryTracker.notifyDeleted(config);
        } else {
            this.managedServiceTracker.notifyDeleted(config);
        }
    }

    void notifyLocationChanged(ConfigurationImpl config, String oldLocation, boolean isFactory) {
        if (isFactory) {
            this.managedServiceFactoryTracker.notifyUpdateLocation(config, oldLocation);
        } else {
            this.managedServiceTracker.notifyUpdateLocation(config, oldLocation);
        }
    }

    Dictionary<String, Object> modifyConfiguration(ServiceReference<?> reference, ConfigurationImpl config) {
        return this.pluginManager.modifyConfiguration(reference, config);
    }

    ConfigurationAdminParticipant coordinationParticipant(Coordination coordination) {
        return coordination.getParticipants().stream().filter(ConfigurationAdminParticipant.class::isInstance).map(ConfigurationAdminParticipant.class::cast).findFirst().orElseGet(() -> new ConfigurationAdminParticipant(coordination));
    }

    Optional<Coordination> coordinate() {
        return Optional.ofNullable((Coordinator)this.coordinationServiceTracker.getService()).map(Coordinator::peek).filter(Predicate.not(Coordination::isTerminated));
    }

    void executeCoordinated(Object key, Runnable runnable) {
        this.coordinate().ifPresentOrElse(coordination -> this.coordinationParticipant((Coordination)coordination).addTask(key, runnable), () -> runnable.run());
    }

    void cancelExecuteCoordinated(Object key) {
        this.coordinate().ifPresent(coordination -> this.coordinationParticipant((Coordination)coordination).cancelTask(key));
    }

    private final class ConfigurationAdminParticipant
    implements Participant {
        private final Map<Object, Runnable> tasks = new LinkedHashMap<Object, Runnable>();

        public ConfigurationAdminParticipant(Coordination coordination) {
            coordination.addParticipant((Participant)this);
        }

        public void ended(Coordination coordination) throws Exception {
            this.finish(coordination);
        }

        public void failed(Coordination coordination) throws Exception {
            this.finish(coordination);
        }

        private void finish(Coordination coordination) {
            this.tasks.values().forEach(Runnable::run);
            this.tasks.clear();
        }

        public void cancelTask(Object key) {
            this.tasks.remove(key);
        }

        public void addTask(Object key, Runnable runnable) {
            this.tasks.put(key, runnable);
        }
    }
}

