/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class StackLayoutTab
extends ExampleTab {
    private static final int COUNT = 5;
    private Composite comp;
    private StackLayout stackLayout;
    private Control[] bArray;
    private int index = 0;
    private boolean propPrefSize;

    public StackLayoutTab() {
        super("StackLayout");
    }

    @Override
    protected void createStyleControls(Composite parent) {
        final Button prefSizeButton = this.createPropertyButton("Preferred Size");
        prefSizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StackLayoutTab.this.propPrefSize = prefSizeButton.getSelection();
                StackLayoutTab.this.createNew();
            }
        });
        Button switchButton = this.createPropertyButton("Next", 8);
        switchButton.setLocation(5, 220);
        switchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StackLayoutTab.this.showNext();
            }
        });
    }

    @Override
    protected void createExampleControls(Composite parent) {
        GridLayout parentLayout = new GridLayout();
        parentLayout.marginWidth = 5;
        parent.setLayout((Layout)parentLayout);
        this.comp = new Composite(parent, 0);
        this.comp.setBackground(new Color((Device)parent.getDisplay(), 204, 183, 145));
        this.stackLayout = new StackLayout();
        this.stackLayout.marginWidth = 3;
        this.stackLayout.marginHeight = 3;
        this.comp.setLayout((Layout)this.stackLayout);
        this.bArray = new Button[5];
        int i = 0;
        while (i < 5) {
            Button button = new Button(this.comp, 8);
            button.setText("Control " + (i + 1));
            button.setFont(new Font((Device)parent.getDisplay(), "Serif", 24, 1));
            this.bArray[i] = button;
            ++i;
        }
        this.stackLayout.topControl = this.bArray[this.index];
        if (this.propPrefSize) {
            this.comp.setLayoutData((Object)new GridData());
        } else {
            this.comp.setLayoutData((Object)new GridData(1808));
        }
        this.comp.layout();
        this.registerControl((Control)this.comp);
    }

    private void showNext() {
        this.index = (this.index + 1) % 5;
        this.stackLayout.topControl = this.bArray[this.index];
        this.comp.layout();
    }
}

