/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.runtime.Assert;

public class EmptyObservableSet
implements IObservableSet {
    private static final Set emptySet = Collections.EMPTY_SET;
    private final Realm realm;
    private Object elementType;

    public EmptyObservableSet(Realm realm) {
        this(realm, null);
    }

    public EmptyObservableSet(Realm realm, Object elementType) {
        this.realm = realm;
        this.elementType = elementType;
        ObservableTracker.observableCreated(this);
    }

    @Override
    public void addSetChangeListener(ISetChangeListener listener) {
    }

    @Override
    public void removeSetChangeListener(ISetChangeListener listener) {
    }

    @Override
    public Object getElementType() {
        return this.elementType;
    }

    @Override
    public int size() {
        this.checkRealm();
        return 0;
    }

    private void checkRealm() {
        Assert.isTrue((boolean)this.realm.isCurrent(), (String)"Observable cannot be accessed outside its realm");
    }

    @Override
    public boolean isEmpty() {
        this.checkRealm();
        return true;
    }

    @Override
    public boolean contains(Object o) {
        this.checkRealm();
        return false;
    }

    @Override
    public Iterator iterator() {
        this.checkRealm();
        return emptySet.iterator();
    }

    @Override
    public Object[] toArray() {
        this.checkRealm();
        return emptySet.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return emptySet.toArray(a);
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        this.checkRealm();
        return c.isEmpty();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addChangeListener(IChangeListener listener) {
    }

    @Override
    public void removeChangeListener(IChangeListener listener) {
    }

    @Override
    public void addStaleListener(IStaleListener listener) {
    }

    @Override
    public void removeStaleListener(IStaleListener listener) {
    }

    @Override
    public void addDisposeListener(IDisposeListener listener) {
    }

    @Override
    public void removeDisposeListener(IDisposeListener listener) {
    }

    @Override
    public boolean isStale() {
        this.checkRealm();
        return false;
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public void dispose() {
    }

    @Override
    public Realm getRealm() {
        return this.realm;
    }

    @Override
    public boolean equals(Object obj) {
        this.checkRealm();
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        return ((Set)obj).isEmpty();
    }

    @Override
    public int hashCode() {
        this.checkRealm();
        return 0;
    }
}

