/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class AttributeAndMappingWithTransparentIndirectionMismatchTest
extends ExceptionTest {
    IntegrityChecker orgIntegrityChecker;

    public AttributeAndMappingWithTransparentIndirectionMismatchTest() {
        this.setDescription("This tests Attribute And Mapping With Transparent Indirection Mismatch (TL-ERROR 138)");
    }

    protected void setup() {
        this.expectedException = DescriptorException.attributeAndMappingWithTransparentIndirectionMismatch((DatabaseMapping)new DirectToFieldMapping(), null, null);
        this.expectedException.setErrorCode(138);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
        this.getSession().setIntegrityChecker(new IntegrityChecker());
        this.getSession().getIntegrityChecker().dontCatchExceptions();
    }

    @Override
    public void reset() {
        if (this.orgIntegrityChecker != null) {
            this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
        }
    }

    public void test() {
        TransparentIndirectionPolicy policy = new TransparentIndirectionPolicy();
        OneToManyMapping mapping = new OneToManyMapping();
        mapping.setAttributeName("manager");
        mapping.setReferenceClass(Employee.class);
        mapping.addTargetForeignKeyFieldName("EMPLOYEE.MANAGER_ID", "EMPLOYEE.EMP_ID");
        policy.setMapping((DatabaseMapping)mapping);
        try {
            policy.validateDeclaredAttributeType(AttributeAndMappingWithTransparentIndirectionMismatchTest.class, this.getSession().getIntegrityChecker());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }
}

