/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.DirectDirectMapHolder;

public class TestReadDirectDirectMapMapping
extends TestCase {
    protected List holders = null;
    protected int fetchJoinRelationship = 0;
    protected int oldFetchJoinValue = 0;
    protected DirectCollectionMapping mapping = null;
    protected Expression holderExp;

    public TestReadDirectDirectMapMapping() {
    }

    public TestReadDirectDirectMapMapping(int fetchJoin) {
        this();
        this.fetchJoinRelationship = fetchJoin;
        this.setName("TestReadDirectDirectMapMapping fetchJoin = " + fetchJoin);
    }

    public void setup() {
        this.mapping = (DirectCollectionMapping)this.getSession().getProject().getDescriptor(DirectDirectMapHolder.class).getMappingForAttributeName("directToDirectMap");
        this.oldFetchJoinValue = this.mapping.getJoinFetch();
        this.mapping.setJoinFetch(this.fetchJoinRelationship);
        this.getSession().getProject().getDescriptor(DirectDirectMapHolder.class).reInitializeJoinedAttributes();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        DirectDirectMapHolder holder = new DirectDirectMapHolder();
        holder.addDirectToDirectMapItem(new Integer(1), new Integer(1));
        holder.addDirectToDirectMapItem(new Integer(2), new Integer(2));
        uow.registerObject((Object)holder);
        uow.commit();
        this.holderExp = new ExpressionBuilder().get("id").equal(holder.getId());
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        this.holders = this.getSession().readAllObjects(DirectDirectMapHolder.class, this.holderExp);
    }

    public void verify() {
        if (this.holders == null || this.holders.size() != 1) {
            throw new TestErrorException("Incorrect number of MapHolders was read.");
        }
        DirectDirectMapHolder holder = (DirectDirectMapHolder)this.holders.get(0);
        if (!((IndirectMap)holder.getDirectToDirectMap()).getValueHolder().isInstantiated() && this.fetchJoinRelationship > 0) {
            throw new TestErrorException("Relationship was not properly joined.");
        }
        if (holder.getDirectToDirectMap().size() != 2) {
            throw new TestErrorException("Incorrect Number of Map values was read.");
        }
        Integer value = (Integer)holder.getDirectToDirectMap().get(1);
        if (value != 1) {
            throw new TestErrorException("Incorrect map value was read.");
        }
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteAllObjects((Collection)this.holders);
        uow.commit();
        if (!this.verifyDelete(this.holders.get(0))) {
            throw new TestErrorException("Delete was unsuccessful.");
        }
        this.mapping.setJoinFetch(this.oldFetchJoinValue);
    }
}

