/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.validation;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.ValidationMode;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCaseHelper;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;

public class ValidationTestSuite
extends JUnitTestCase {
    public ValidationTestSuite() {
    }

    public ValidationTestSuite(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ValidationTestSuite.class){

            protected void setUp() {
            }

            protected void tearDown() {
            }
        };
        suite.setName("ValidationTestSuite");
        return suite;
    }

    public void testCacheIsolation_PropertiesDefault_Config() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>(JUnitTestCaseHelper.getDatabaseProperties());
        properties.put("eclipselink.cache.shared.default", Boolean.FALSE.toString());
        EntityManager em = ValidationTestSuite.createEntityManager((String)"isolated1053", properties);
        ValidationTestSuite.assertTrue((String)"Item descriptor did not have an isolated cache setting from a TopLink properties setting.", (boolean)((EntityManagerImpl)em).getServerSession().getClassDescriptorForAlias("Item").isIsolated());
        this.closeEntityManager(em);
        ValidationTestSuite.closeEntityManagerFactory((String)"isolated1053");
    }

    public void testCacheIsolation_XMLDefault_Config() throws Exception {
        EntityManager em = ValidationTestSuite.createEntityManager((String)"isolated1053");
        ValidationTestSuite.assertTrue((String)"Item descriptor did not have an isolated cache setting from an XML setting.", (boolean)((EntityManagerImpl)em).getServerSession().getClassDescriptorForAlias("Item").isIsolated());
        this.closeEntityManager(em);
        ValidationTestSuite.closeEntityManagerFactory((String)"isolated1053");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJTADatasource_Config_Override() throws Exception {
        boolean pass = false;
        HashMap<String, tmpDataSourceImp> properties = new HashMap<String, tmpDataSourceImp>();
        tmpDataSourceImp jtadatasourece = new tmpDataSourceImp();
        properties.put("javax.persistence.jtaDataSource", jtadatasourece);
        EntityManager em = null;
        try {
            em = ValidationTestSuite.createEntityManager((String)"ignore", properties);
        }
        catch (RuntimeException expected) {
            boolean bl = pass = expected.getMessage().indexOf("tmpDataSourceImp getConnection called") != -1;
            if (!pass) {
                throw expected;
            }
        }
        finally {
            if (em != null) {
                this.closeEntityManager(em);
            }
            ValidationTestSuite.closeEntityManagerFactory((String)"ignore");
        }
        ValidationTestSuite.assertTrue((String)"JTA datasource was not set or accessed as expected through map of properties", (boolean)pass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonJTADatasource_Config_Override() throws Exception {
        boolean pass = false;
        HashMap<String, tmpDataSourceImp> properties = new HashMap<String, tmpDataSourceImp>();
        tmpDataSourceImp nonJTADatasourece = new tmpDataSourceImp();
        properties.put("javax.persistence.nonJtaDataSource", nonJTADatasourece);
        EntityManager em = null;
        try {
            em = ValidationTestSuite.createEntityManager((String)"ignore", properties);
        }
        catch (RuntimeException expected) {
            boolean bl = pass = expected.getMessage().indexOf("tmpDataSourceImp getConnection called") != -1;
            if (!pass) {
                throw expected;
            }
        }
        finally {
            if (em != null) {
                this.closeEntityManager(em);
            }
            ValidationTestSuite.closeEntityManagerFactory((String)"ignore");
        }
        ValidationTestSuite.assertTrue((String)"Non JTA datasource was not set or accessed as expected through map of properties", (boolean)pass);
    }

    public void testPKClassTypeValidation() {
        try {
            this.createEntityManager().find(Employee.class, (Object)new Employee());
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        ValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException, when incorrect PKClass is used in find call");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidValidationModes() {
        if (ValidationTestSuite.isJPA10()) {
            return;
        }
        String property = "javax.persistence.validation.mode";
        String[] validationModes = new String[]{"none", "NONE", "NoNe", ValidationMode.NONE.name(), "auto", "AUTO", "AuTo", ValidationMode.AUTO.name()};
        this.closeEntityManagerFactory();
        for (String validationMode : validationModes) {
            block7: {
                EntityManager em = null;
                try {
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.putAll(JUnitTestCaseHelper.getDatabaseProperties());
                    props.put(property, validationMode);
                    em = this.createEntityManager(props);
                    if (em == null) break block7;
                }
                catch (RuntimeException exception) {
                    block8: {
                        try {
                            ValidationTestSuite.fail((String)("Exception caught when passing property: [" + property + "] = [" + validationMode + "] when creating an EntityManager: " + exception.getMessage()));
                            if (em == null) break block8;
                        }
                        catch (Throwable throwable) {
                            if (em != null) {
                                this.closeEntityManager(em);
                            }
                            this.closeEntityManagerFactory();
                            throw throwable;
                        }
                        this.closeEntityManager(em);
                    }
                    this.closeEntityManagerFactory();
                    continue;
                }
                this.closeEntityManager(em);
            }
            this.closeEntityManagerFactory();
        }
    }

    public class tmpDataSourceImp
    implements DataSource {
        @Override
        public Connection getConnection() throws SQLException {
            RuntimeException exception = new RuntimeException("tmpDataSourceImp getConnection called");
            throw exception;
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return this.getConnection();
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return null;
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return 1;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }

        @Override
        public Logger getParentLogger() {
            return null;
        }
    }
}

