/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.  
 *
 * This software is the proprietary information of Oracle Corporation.
 * Use is subject to license terms.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import org.eclipse.persistence.annotations.TenantTableDiscriminatorType;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalTenantTableDiscriminator;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

/**
 * The external form of the tenant table discriminator.
 *
 * @version 2.6
 */
final class TenantTableDiscriminator extends AbstractExternalForm
                                     implements ExternalTenantTableDiscriminator {

	/**
	 * Creates a new <code>TenantTableDiscriminator</code>.
	 * 
	 * @param parent The parent of this external form
	 */
	public TenantTableDiscriminator(MultitenancyPolicy parent) {
		super(parent);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getContextProperty() {
		return getAttribute(CONTEXT_PROPERTY);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getContextPropertyTextRange() {
		return getAttributeTextRange(CONTEXT_PROPERTY);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TenantTableDiscriminatorType getDiscriminatorType() {
		return getEnumAttribute(TENANT_TABLE_DISCRIMINATOR_TYPE, TenantTableDiscriminatorType.class);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getDiscriminatorTypeTextRange() {
		return getAttributeTextRange(TENANT_TABLE_DISCRIMINATOR_TYPE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected Element getElement() {
		return getChild(getParent(), getElementName());
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return TENANT_TABLE_DISCRIMINATOR;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setContextProperty(String contextProperty) {
		setAttribute(CONTEXT_PROPERTY, contextProperty);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDiscriminatorType(TenantTableDiscriminatorType type) {
		setAttribute(TENANT_TABLE_DISCRIMINATOR_TYPE, type);
	}
}