/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import org.w3c.dom.Element;

/**
 * The external form of the tenant discriminator column defined on a persistence unit.
 *
 * @version 2.6
 */
final class PersistenceUnitTenantDiscriminatorColumn extends AbstractTenantDiscriminatorColumn {

	/**
	 * Creates a new <code>PersistenceUnitTenantDiscriminatorColumn</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the external form of the mapping in the list of children
	 */
	PersistenceUnitTenantDiscriminatorColumn(PersistenceUnit parent, int index) {
		super(parent, index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected Element addSelf(String elementName) {

		Element element = getChild(getParent(), PersistenceUnit.PERSISTENCE_UNIT_DEFAULTS);

		if (element == null) {
			element = addChild(getParent(), PersistenceUnit.PERSISTENCE_UNIT_DEFAULTS);
		}

		return addChild(element, elementName);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected Element getElement() {

		Element element = getChild(getParent(), PersistenceUnit.PERSISTENCE_UNIT_DEFAULTS);

		if (element != null) {
			return getChild(element, TENANT_DISCRIMINATOR_COLUMN, getIndex());
		}

		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void removeSelf() {

		Element element = getChild(getParent(), PersistenceUnit.PERSISTENCE_UNIT_DEFAULTS);

		if (element != null) {
			removeChild(element, getElementName(), getIndex());
		}
	}
}