/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;
import javax.persistence.CascadeType;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface represents the basis for all variable one to one mapping types defined by the
 * EclipseLink JPA spec that are available for configuration via the EclipseLink ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalVariableOneToOneMapping extends ExternalMappedMapping,
                                                         ExternalPrivatelyOwnableMapping,
                                                         ExternalOrphanRemovableMapping {

	/**
	 * The element name used to store and retrieve the mutable child text node.
	 */
	String CASCADE = "cascade";

	/**
	 * The name of the element used to specify the cascade-all property.
	 */
	String CASCADE_ALL = "cascade-all";

	/**
	 * The name of the element used to specify the cascade-detach property.
	 */
	String CASCADE_DETACH = "cascade-detach";

	/**
	 * The name of the element used to specify the cascade-merge property.
	 */
	String CASCADE_MERGE = "cascade-merge";

	/**
	 * The name of the element used to specify the cascade-persist property.
	 */
	String CASCADE_PERSIST = "cascade-persist";

	/**
	 * The name of the element used to specify the cascade-refresh property.
	 */
	String CASCADE_REFRESH = "cascade-refresh";

	/**
	 * The name of the element used to specify the cascade-remove property.
	 */
	String CASCADE_REMOVE = "cascade-remove";

	/**
	 * The attribute name used to store and retrieve the fetch property.
	 */
	String FETCH = "fetch";

	/**
	 * The attribute name used to store and retrieve the optional property.
	 */
	String OPTIONAL = "optional";

	/**
	 * The element name used to store and retrieve the private-owned element.
	 */
	String PRIVATE_OWNED = "private-owned";

	/**
	 * The attribute name used to store and retrieve the target-interface property.
	 */
	String TARGET_INTERFACE = "target-interface";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String VARIABLE_ONE_TO_ONE = "variable-one-to-one";

	/**
	 * Visits this {@link ExternalVariableOneToOneMapping} by the given {@link ExternalMappingVisitor visitor}.
	 *
	 * @param visitor The {@link ExternalMappingVisitor} to visit this object
	 */
	void accept(ExternalMappingVisitor visitor);

	/**
	 * Adds a cascaded type to use.
	 */
	void addCascadeType(CascadeType type);

	/**
	 * Adds a discriminator class with the given values.
	 */
	ExternalDiscriminatorClass addDiscriminatorClass(String discrimator, String value);

	/**
	 * Creates a new discriminator column definition replacing the old one.
	 */
	ExternalDiscriminatorColumn addDiscriminatorColumn();

	/**
	 * Adds a join column with the given name.
	 */
	ExternalJoinColumn addJoinColumn(String name);

	/**
	 * Returns the enum, CascadeType to use for this relationship.
	 */
	List<CascadeType> cascadeTypes();

	/**
	 * Returns the discriminator class for this mapping.
	 */
	List<ExternalDiscriminatorClass> discriminatorClasses();

	/**
	 * Returns the count of discriminator classes for this mapping.
	 */
	int discriminatorClassesSize();

	/**
	 * Returns a discriminator class with the given target class name and value.
	 */
	ExternalDiscriminatorClass getDiscriminatorClass(String value, String discriminator);

	/**
	 * Returns the discriminator column definition.
	 */
	ExternalDiscriminatorColumn getDiscriminatorColumn();

	/**
	 * Returns a join column with the given name
	 */
	ExternalJoinColumn getJoinColumn(int index);

	/**
	 * Returns the target interface name for this mapping.
	 */
	String getTargetInterfaceName();

	/**
	 * Returns the {@link TextRange} for the target interface name value.
	 */
	TextRange getTargetInterfaceNameTextRange();

	/**
	 * Returns the join column for this mapping.
	 */
	List<ExternalJoinColumn> joinColumns();

	/**
	 * Returns the count of join columns for this mapping.
	 */
	int joinColumnsSize();

	/**
	 * Removes a cascade type.
	 */
	void removeCascadeType(CascadeType type);

	/**
	 * Removes the discriminator class at the given position.
	 */
	void removeDiscriminatorClass(int index);

	/**
	 * Removes the discriminator column definition.
	 */
	void removeDiscriminatorColumn();

	/**
	 * Removes the join column at the given position.
	 */
	void removeJoinColumn(int index);

	/**
	 * Sets the target interface name.
	 */
	void setTargetInterfaceName(String entityName);
}