/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;
import org.eclipse.persistence.tools.mapping.ExternalForm;

/**
 * Defines an external ORM object that holds on to {@link ExternalTenantDiscriminatorColumn}.
 * Implementors of this interface know how to retrieve, remove, and create an tenant discriminator
 * column.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see ExternalTenantDiscriminatorColumn
 *
 * @version 2.6
 */
public interface ExternalTenantDiscriminatorColumnProvider extends ExternalForm {

	/**
	 * Adds a new discriminator column.
	 */
	ExternalTenantDiscriminatorColumn addDiscriminatorColumn();

	/**
	 * Returns all discriminator columns.
	 */
	List<ExternalTenantDiscriminatorColumn> discriminatorColumns();

	/**
	 * Returns the number of discriminator columns.
	 */
	int discriminatorColumnSize();

	/**
	 * Returns the discriminator column at the given index.
	 */
	ExternalTenantDiscriminatorColumn getDiscriminatorColumn(int index);

	/**
	 * Removes the discriminator column at the given position.
	 */
	void removeDiscriminatorColumn(int index);
}