/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;
import org.eclipse.persistence.annotations.OptimisticLockingType;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and inherited behavior describe the configurable properties defined for an
 * optimistic locking definition in the EclipseLink 1.1 ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see org.eclipse.persistence.annotations.OptimisticLocking
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalOptimisticLocking extends ExternalForm {

	/**
	 * The attribute name used to store and retrieve the cascade property.
	 */
	String CASCADE = "cascade";

	/**
	 * The attribute name used to store and retrieve the optimistic-locking property.
	 */
	String OPTIMISTIC_LOCKING = "optimistic-locking";

	/**
	 * The element name used to store and retrieve the base child node.
	 */
	String SELECTED_COLUMN = "selected-column";

	/**
	 * The attribute name used to store and retrieve the type property.
	 */
	String TYPE = "type";

	/**
	 * Adds column with the provided column name.
	 */
	ExternalEntityColumn addColumn(String columnName);

	/**
	 * Returns a list of all columns defined for this primary key definition.
	 */
	List<ExternalEntityColumn> columns();

	/**
	 * Returns the count of all columns defined for this table definition.
	 */
	int columnsSize();

	/**
	 * Returns the {@link TextRange} for the cascade value.
	 */
	TextRange getCascadeTextRange();

	/**
	 * Returns the column at the specified index.
	 */
	ExternalEntityColumn getColumn(int index);

	/**
	 * Returns the {@link TextRange} of the column specified.
	 */
	TextRange getColumnTextRange(String columnName);

	/**
	 * Returns the locking type.
	 */
	OptimisticLockingType getOptimisticLockingType();

	/**
	 * Returns the {@link TextRange} for the optimistic locking type value.
	 */
	TextRange getOptimisticLockingTypeTextRange();

	/**
	 * Removes all the columns owned by this primary key.
	 */
	void removeAllColumns();

	/**
	 * Removes the column at the given position.
	 */
	void removeColumn(int index);

	/**
	 * Sets the locking type.
	 */
	void setOptimisticLockingType(OptimisticLockingType type);

	/**
	 * Sets whether this should cascade.
	 */
	void setShouldCascade(Boolean value);

	/**
	 * Returns whether this should cascade.
	 */
	Boolean shouldCascade();
}