/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and inherited behavior describe the configurable properties defined for a join
 * column in the ORM xml. A join column is used inside a join table to describing multi table
 * association.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.JoinColumn
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalJoinColumn extends ExternalBasicColumn {

	/**
	 * The attribute name used to store and retrieve the base property.
	 */
	String BASE = "base";

	/**
	 * The attribute name used to store and retrieve the contiguous property.
	 */
	String CONTIGUOUS = "contiguous";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String JOIN_COLUMN = "join-column";

	/**
	 * The attribute name used to store and retrieve the mapped-by property.
	 */
	String REFERENCED_COLUMN_NAME = "referenced-column-name";

	/**
	 * Returns the base integer for this column
	 */
	Integer getBase();

	/**
	 * Returns the target column name referenced by this join column.
	 */
	String getReferenceColumnName();

	/**
	 * Returns the {@link TextRange} for the target column name referenced by this join column.
	 */
	TextRange getReferenceColumnNameTextRange();

	/**
	 * Returns boolean indicating whether or not this column is contiguous
	 */
	Boolean isContiguous();

	/**
	 * Sets the base integer for this column
	 */
	void setBase(Integer base);

	/**
	 * sets whether or not this column is contiguous
	 */
	void setContiguous(Boolean contiguous);

	/**
	 * Set the target column name referenced by this join column.
	 */
	void setReferenceColumnName(String name);
}