/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and inherited behavior describe the configurable properties defined for a field
 * result in the ORM xml. Used inside an entity result to describe query result mapping.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.NamedNativeQuery
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalFieldResult extends ExternalForm {

	/**
	 * The attribute name used to store and retrieve the map-key property.
	 */
	String COLUMN = "column";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String FIELD_RESULT = "field-result";

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	String NAME = "name";

	/**
	 * Returns the column name associated with this result.
	 */
	String getColumnName();

	/**
	 * Returns the {@link TextRange} for the column name associated with this result.
	 */
	TextRange getColumnNameTextRange();

	/**
	 * Returns the name of the field result.
	 */
	String getName();

	/**
	 * Returns the {@link TextRange} for the name of the field result.
	 */
	TextRange getNameTextRange();

	/**
	 * Sets the column name.
	 */
	void setColumnName(String name);

	/**
	 * Sets the name of the field result.
	 */
	void setName(String name);
}