/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.model.value;

import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.collection.CollectionTools;
import org.eclipse.persistence.tools.utility.collection.HashBag;
import org.eclipse.persistence.tools.utility.model.value.CollectionValueModel;
import org.eclipse.persistence.tools.utility.model.value.StaticCollectionValueModel;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class StaticCollectionValueModelTests
extends TestCase {
    private static final Collection<String> COLLECTION = StaticCollectionValueModelTests.buildCollection();
    private CollectionValueModel<String> collectionHolder;

    private static Collection<String> buildCollection() {
        HashBag result = new HashBag();
        result.add("foo");
        result.add("bar");
        return result;
    }

    public StaticCollectionValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.collectionHolder = this.buildCollectionHolder();
    }

    private CollectionValueModel<String> buildCollectionHolder() {
        return new StaticCollectionValueModel(COLLECTION);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testIterator() {
        StaticCollectionValueModelTests.assertEquals(StaticCollectionValueModelTests.buildCollection(), (Object)CollectionTools.bag((Iterator)this.collectionHolder.iterator()));
    }

    public void testSize() {
        StaticCollectionValueModelTests.assertEquals((int)StaticCollectionValueModelTests.buildCollection().size(), (int)this.collectionHolder.size());
    }
}

