/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.filter;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class FilterTests
extends TestCase {
    public FilterTests(String name) {
        super(name);
    }

    public void testNullFilter() {
        Filter filter = Filter.Transparent.instance();
        FilterTests.assertTrue((boolean)filter.accept((Object)""));
        FilterTests.assertTrue((boolean)filter.accept((Object)"foo"));
        FilterTests.assertTrue((boolean)filter.accept((Object)"bar"));
    }

    public void testNullFilter_toString() {
        Filter filter = Filter.Transparent.instance();
        FilterTests.assertNotNull((Object)filter.toString());
    }

    public void testNullFilter_serialization() throws Exception {
        Filter filter = Filter.Transparent.instance();
        FilterTests.assertSame((Object)filter, (Object)TestTools.serialize(filter));
    }

    public void testOpaqueFilter() {
        Filter filter = Filter.Opaque.instance();
        FilterTests.assertFalse((boolean)filter.accept((Object)""));
        FilterTests.assertFalse((boolean)filter.accept((Object)"foo"));
        FilterTests.assertFalse((boolean)filter.accept((Object)"bar"));
    }

    public void testOpaqueFilter_toString() {
        Filter filter = Filter.Opaque.instance();
        FilterTests.assertNotNull((Object)filter.toString());
    }

    public void testOpaqueFilter_serialization() throws Exception {
        Filter filter = Filter.Opaque.instance();
        FilterTests.assertSame((Object)filter, (Object)TestTools.serialize(filter));
    }

    public void testDisabledFilter() {
        Filter filter = Filter.Disabled.instance();
        boolean exCaught = false;
        try {
            FilterTests.assertFalse((boolean)filter.accept((Object)"foo"));
            FilterTests.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        FilterTests.assertTrue((boolean)exCaught);
    }

    public void testDisabledFilter_toString() {
        Filter filter = Filter.Disabled.instance();
        FilterTests.assertNotNull((Object)filter.toString());
    }

    public void testDisabledFilter_serialization() throws Exception {
        Filter filter = Filter.Disabled.instance();
        FilterTests.assertSame((Object)filter, (Object)TestTools.serialize(filter));
    }
}

