/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalPrimaryKeyJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalSecondaryTable;
import org.eclipse.persistence.tools.mapping.orm.dom.Entity;
import org.eclipse.persistence.tools.mapping.orm.dom.PrimaryKeyJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.Table;
import org.w3c.dom.Element;

final class SecondaryTable
extends Table
implements ExternalSecondaryTable {
    private int index;

    SecondaryTable(Entity parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    public ExternalPrimaryKeyJoinColumn addPrimaryKeyJoinColumn(String name) {
        PrimaryKeyJoinColumn primaryKeyJoinColumn = this.buildPrimaryKeyJoinColumn(-1);
        primaryKeyJoinColumn.addSelf();
        primaryKeyJoinColumn.setName(name);
        return primaryKeyJoinColumn;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("primary-key-join-column");
        names.add("unique-constraint");
        return names;
    }

    private PrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(int index) {
        return new PrimaryKeyJoinColumn(this, index);
    }

    @Override
    protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
        if (elementName == this.getElementName()) {
            this.index = this.index(parent, child, elementName);
        }
    }

    @Override
    public Element getElement() {
        if (this.index == -1) {
            return super.getElement();
        }
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return "secondary-table";
    }

    @Override
    public ExternalPrimaryKeyJoinColumn getPrimaryKeyJoinColumn(int index) {
        if (this.hasChild("primary-key-join-column", index)) {
            return this.buildPrimaryKeyJoinColumn(index);
        }
        return null;
    }

    @Override
    public List<ExternalPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        int count = this.primaryKeyJoinColumnsSize();
        ArrayList<ExternalPrimaryKeyJoinColumn> primaryKeyJoinColumns = new ArrayList<ExternalPrimaryKeyJoinColumn>(count);
        int index = 0;
        while (index < count) {
            primaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn(index));
            ++index;
        }
        return primaryKeyJoinColumns;
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.getChildrenSize("primary-key-join-column");
    }

    @Override
    public void removeAllPrimaryKeyJoinColumns() {
        this.removeChildren("primary-key-join-column");
    }

    @Override
    public void removePrimaryKeyJoinColumn(int index) {
        PrimaryKeyJoinColumn pkJoinColumn = this.buildPrimaryKeyJoinColumn(index);
        pkJoinColumn.removeSelf();
    }

    @Override
    public void removeSelf() {
        if (this.index == -1) {
            super.removeSelf();
        } else {
            this.removeChild(this.getParent(), this.getElementName(), this.index);
        }
    }
}

