/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalPrimaryKeyJoinColumn;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

final class PrimaryKeyJoinColumn
extends AbstractExternalForm
implements ExternalPrimaryKeyJoinColumn {
    private int index;

    PrimaryKeyJoinColumn(AbstractExternalForm parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("referenced-column-name");
        names.add("column-definition");
        return names;
    }

    @Override
    protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
        if (elementName == this.getElementName()) {
            this.index = this.index(parent, child, elementName);
        }
    }

    @Override
    public String getColumnDefinition() {
        return this.getAttribute("column-definition");
    }

    @Override
    public TextRange getColumnDefinitionTextRange() {
        return this.getAttributeTextRange("column-definition");
    }

    @Override
    public Element getElement() {
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return "primary-key-join-column";
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getAttributeTextRange("name");
    }

    @Override
    public String getReferenceColumnName() {
        return this.getAttribute("referenced-column-name");
    }

    @Override
    public TextRange getReferenceColumnNameTextRange() {
        return this.getAttributeTextRange("referenced-column-name");
    }

    @Override
    public void removeSelf() {
        this.removeChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    public void setColumnDefinition(String definition) {
        this.setAttribute("column-definition", definition);
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public void setReferenceColumnName(String name) {
        this.setAttribute("referenced-column-name", name);
    }
}

