/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.ExternalProperty;
import org.eclipse.persistence.tools.mapping.orm.AccessType;
import org.eclipse.persistence.tools.mapping.orm.ExternalAccessMethods;
import org.eclipse.persistence.tools.mapping.orm.ExternalNonTransientMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.AccessMethods;
import org.eclipse.persistence.tools.mapping.orm.dom.Embeddable;
import org.eclipse.persistence.tools.mapping.orm.dom.Mapping;
import org.eclipse.persistence.tools.mapping.orm.dom.Property;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.TextRange;

abstract class NonTransientMapping
extends Mapping
implements ExternalNonTransientMapping {
    NonTransientMapping(Embeddable parent) {
        super(parent);
    }

    @Override
    public final ExternalAccessMethods addAccessMethods(String getMethodName, String setMethodName) {
        AccessMethods accessMethods = this.buildAccessMethods();
        accessMethods.addSelf();
        accessMethods.setGetMethod(getMethodName);
        accessMethods.setSetMethod(setMethodName);
        return accessMethods;
    }

    @Override
    public final ExternalProperty addProperty(String name, String value) {
        Property property = this.buildProperty(-1);
        property.addSelf();
        property.setName(name);
        property.setValue(value);
        return property;
    }

    private AccessMethods buildAccessMethods() {
        return new AccessMethods(this);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private Property buildProperty(int index) {
        return new Property(this, index);
    }

    @Override
    public final ExternalAccessMethods getAccessMethods() {
        if (this.hasChild("access-methods")) {
            return this.buildAccessMethods();
        }
        return null;
    }

    @Override
    public final AccessType getAccessType() {
        return this.getEnumAttribute("access", AccessType.class);
    }

    @Override
    public final TextRange getAccessTypeTextRange() {
        return this.getAttributeTextRange("access");
    }

    @Override
    public final List<ExternalProperty> getProperties(String name) {
        ArrayList<ExternalProperty> properties = new ArrayList<ExternalProperty>();
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            properties.add(property);
        }
        return properties;
    }

    @Override
    public final ExternalProperty getProperty(int index) {
        if (this.hasChild("property", index)) {
            return this.buildProperty(index);
        }
        return null;
    }

    @Override
    public final ExternalProperty getProperty(String name) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            return property;
        }
        return null;
    }

    @Override
    public final ExternalProperty getProperty(String name, int index) {
        ExternalProperty property = this.getProperty(index);
        if (property != null && ObjectTools.equals((Object)name, (Object)property.getName())) {
            return property;
        }
        return null;
    }

    @Override
    public final ExternalProperty getProperty(String name, String value) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name) || !ObjectTools.equals((Object)property.getValue(), (Object)value)) continue;
            return property;
        }
        return null;
    }

    @Override
    public final TextRange getPropertyNameTextRange(String name) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            return property.getNameTextRange();
        }
        return null;
    }

    @Override
    public final TextRange getPropertyTextRange(String name) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            return property.getTextRange();
        }
        return null;
    }

    @Override
    public final TextRange getPropertyTextRange(String name, String value) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name) || !ObjectTools.equals((Object)property.getValue(), (Object)value)) continue;
            return property.getTextRange();
        }
        return null;
    }

    @Override
    public final TextRange getPropertyValueTextRange(String name) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            return property.getValueTextRange();
        }
        return null;
    }

    @Override
    public final List<ExternalProperty> properties() {
        int count = this.propertiesSize();
        ArrayList<ExternalProperty> properties = new ArrayList<ExternalProperty>(count);
        int index = 0;
        while (index < count) {
            properties.add(this.buildProperty(index));
            ++index;
        }
        return properties;
    }

    @Override
    public final int propertiesSize() {
        return this.getChildrenSize("property");
    }

    @Override
    public final int propertiesSize(String name) {
        int count = 0;
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public final void removeAccessMethods() {
        this.removeChild("access-methods");
    }

    @Override
    public final void removeProperty(int index) {
        Property property = this.buildProperty(index);
        property.removeSelf();
    }

    @Override
    public final void removeProperty(String name) {
        Property property = (Property)this.getProperty(name);
        property.removeSelf();
    }

    @Override
    public final void removeProperty(String name, String value) {
        Property property = (Property)this.getProperty(name, value);
        property.removeSelf();
    }

    @Override
    public final void setAccessType(AccessType type) {
        this.setAttribute("access", type);
    }
}

