/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalManyToOneMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalMappingVisitor;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSqlJoinField;
import org.eclipse.persistence.tools.mapping.orm.dom.Embeddable;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.NoSqlJoinField;
import org.eclipse.persistence.tools.mapping.orm.dom.RelationshipMapping;
import org.eclipse.persistence.tools.utility.TextRange;

final class ManyToOneMapping
extends RelationshipMapping
implements ExternalManyToOneMapping {
    ManyToOneMapping(Embeddable parent) {
        super(parent);
    }

    @Override
    public void accept(ExternalMappingVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ExternalJoinColumn addJoinColumn(String name) {
        JoinColumn joinColumn = this.buildJoinColumn(-1);
        joinColumn.addSelf();
        joinColumn.setName(name);
        return joinColumn;
    }

    @Override
    public ExternalNoSqlJoinField addJoinField(String name) {
        NoSqlJoinField joinField = this.buildJoinField(-1);
        joinField.addSelf();
        joinField.setName(name);
        return joinField;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("target-entity");
        names.add("fetch");
        names.add("optional");
        names.add("access");
        names.add("mapped-by-id");
        names.add("maps-id");
        names.add("id");
        return names;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("join-column");
        names.add("join-table");
        names.add("join-fetch");
        names.add("batch-fetch");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private JoinColumn buildJoinColumn(int index) {
        return new JoinColumn(this, "join-column", index);
    }

    private NoSqlJoinField buildJoinField(int index) {
        return new NoSqlJoinField(this, index);
    }

    @Override
    protected String getElementName() {
        return "many-to-one";
    }

    @Override
    public Boolean getId() {
        return this.getBooleanAttribute("id");
    }

    @Override
    public TextRange getIdTextRange() {
        return this.getAttributeTextRange("id");
    }

    @Override
    public ExternalJoinColumn getJoinColumn(int index) {
        if (this.hasChild("join-column", index)) {
            return this.buildJoinColumn(index);
        }
        return null;
    }

    @Override
    public String getMappedByMappingName() {
        return this.getAttribute("mapped-by-id");
    }

    @Override
    public TextRange getMappedByMappingNameTextRange() {
        return this.getAttributeTextRange("mapped-by-id");
    }

    @Override
    public String getMapsId() {
        return this.getAttribute("maps-id");
    }

    @Override
    public TextRange getMapsIdTextRange() {
        return this.getAttributeTextRange("maps-id");
    }

    @Override
    public List<ExternalJoinColumn> joinColumns() {
        int count = this.joinColumnsSize();
        ArrayList<ExternalJoinColumn> joinColumns = new ArrayList<ExternalJoinColumn>(count);
        int index = 0;
        while (index < count) {
            joinColumns.add(this.buildJoinColumn(index));
            ++index;
        }
        return joinColumns;
    }

    @Override
    public int joinColumnsSize() {
        return this.getChildrenSize("join-column");
    }

    @Override
    public List<ExternalNoSqlJoinField> joinFields() {
        int count = this.joinFieldSize();
        ArrayList<ExternalNoSqlJoinField> joinFields = new ArrayList<ExternalNoSqlJoinField>(count);
        int index = 0;
        while (index < count) {
            joinFields.add(this.buildJoinField(index));
            ++index;
        }
        return joinFields;
    }

    @Override
    public int joinFieldSize() {
        return this.getChildrenSize("join-field");
    }

    @Override
    public void removeJoinColumn(int index) {
        JoinColumn joinColumn = this.buildJoinColumn(index);
        joinColumn.removeSelf();
    }

    @Override
    public void removeJoinField(int index) {
        this.removeChild("join-field", index);
    }

    @Override
    public void setId(Boolean id) {
        this.setAttribute("id", id);
    }

    @Override
    public void setMappedByMappingName(String name) {
        this.setAttribute("mapped-by-id", name);
    }

    @Override
    public void setMapsId(String mapsId) {
        this.setAttribute("maps-id", mapsId);
    }
}

