/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractColumn;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

class JoinColumn
extends AbstractColumn
implements ExternalJoinColumn {
    private final String elementName;
    private int index;

    JoinColumn(AbstractExternalForm parent, String elementName, int index) {
        super(parent);
        this.index = index;
        this.elementName = elementName;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("referenced-column-name");
        names.add("unique");
        names.add("nullable");
        names.add("insertable");
        names.add("updatable");
        names.add("column-definition");
        names.add("contiguous");
        names.add("base");
        names.add("table");
        return names;
    }

    @Override
    protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
        if (elementName == this.getElementName()) {
            this.index = this.index(parent, child, elementName);
        }
    }

    @Override
    public final Integer getBase() {
        return this.getIntegerAttribute("base");
    }

    @Override
    public final Element getElement() {
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return this.elementName;
    }

    @Override
    public final String getReferenceColumnName() {
        return this.getAttribute("referenced-column-name");
    }

    @Override
    public final TextRange getReferenceColumnNameTextRange() {
        return this.getAttributeTextRange("referenced-column-name");
    }

    @Override
    public final Boolean isContiguous() {
        return this.getBooleanAttribute("contiguous");
    }

    @Override
    public final void removeSelf() {
        this.removeChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    public final void setBase(Integer base) {
        this.setAttribute("base", base);
    }

    @Override
    public final void setContiguous(Boolean contiguous) {
        this.setAttribute("contiguous", contiguous);
    }

    @Override
    public final void setReferenceColumnName(String name) {
        this.setAttribute("referenced-column-name", name);
    }
}

