/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.InheritanceType;
import org.eclipse.persistence.tools.mapping.orm.ExternalDiscriminatorColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntity;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityTable;
import org.eclipse.persistence.tools.mapping.orm.ExternalPrimaryKeyJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalSQLResultSetMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalSecondaryTable;
import org.eclipse.persistence.tools.mapping.orm.dom.DiscriminatorColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.MappedSuperclass;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.dom.PrimaryKeyJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.PrimaryTable;
import org.eclipse.persistence.tools.mapping.orm.dom.SQLResultSetMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.SecondaryTable;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

final class Entity
extends MappedSuperclass
implements ExternalEntity {
    Entity(ORMConfiguration parent, int index) {
        super(parent, index);
    }

    @Override
    public ExternalDiscriminatorColumn addDiscriminatorColumn(String columnName) {
        DiscriminatorColumn column = this.getDiscriminatorColumn();
        if (column == null) {
            column = this.buildDiscriminatorColumn();
            column.addSelf();
        }
        column.setName(columnName);
        return column;
    }

    @Override
    public ExternalPrimaryKeyJoinColumn addPrimaryKeyJoinColumn(String name) {
        PrimaryKeyJoinColumn pkJoinColumn = this.buildPrimaryKeyJoinColumn(-1);
        pkJoinColumn.addSelf();
        pkJoinColumn.setName(name);
        return pkJoinColumn;
    }

    @Override
    public ExternalEntityTable addPrimaryTable(String tableName) {
        PrimaryTable primaryTable = this.buildPrimaryTable();
        primaryTable.addSelf();
        primaryTable.setName(tableName);
        return primaryTable;
    }

    @Override
    public ExternalSecondaryTable addSecondaryTable(String name, String catalog, String schema) {
        SecondaryTable secondaryTable = this.buildSecondaryTable(-1);
        secondaryTable.addSelf();
        secondaryTable.setName(name);
        secondaryTable.setCatalogName(catalog);
        secondaryTable.setSchemaName(schema);
        return secondaryTable;
    }

    @Override
    public ExternalSQLResultSetMapping addSqlResultSetMapping(String name) {
        SQLResultSetMapping sqlResultSetMapping = this.buildSqlResultSetMapping(-1);
        sqlResultSetMapping.addSelf();
        sqlResultSetMapping.setName(name);
        return sqlResultSetMapping;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("class");
        names.add("parent-class");
        names.add("access");
        names.add("cacheable");
        names.add("metadata-complete");
        names.add("read-only");
        names.add("existence-checking");
        names.add("exclude-default-mappings");
        return names;
    }

    private DiscriminatorColumn buildDiscriminatorColumn() {
        return new DiscriminatorColumn(this);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("description");
        names.add("access-methods");
        names.add("multitenant");
        names.add("additional-criteria");
        names.add("customizer");
        names.add("change-tracking");
        names.add("table");
        names.add("secondary-table");
        names.add("struct");
        names.add("primary-key-join-column");
        names.add("primary-key-foreign-key");
        names.add("no-sql");
        names.add("cascade-on-delete");
        names.add("index");
        names.add("id-class");
        names.add("primary-key");
        names.add("inheritance");
        names.add("discriminator-value");
        names.add("discriminator-column");
        names.add("class-extractor");
        names.add("optimistic-locking");
        names.add("cache");
        names.add("cache-interceptor");
        names.add("cache-index");
        names.add("fetch-group");
        names.add("converter");
        names.add("type-converter");
        names.add("object-type-converter");
        names.add("serialized-converter");
        names.add("struct-converter");
        names.add("copy-policy");
        names.add("instantiation-copy-policy");
        names.add("clone-copy-policy");
        names.add("serialized-object");
        names.add("sequence-generator");
        names.add("table-generator");
        names.add("uuid-generator");
        names.add("partitioning");
        names.add("replication-partitioning");
        names.add("round-robin-partitioning");
        names.add("pinned-partitioning");
        names.add("range-partitioning");
        names.add("value-partitioning");
        names.add("hash-partitioning");
        names.add("union-partitioning");
        names.add("partitioned");
        names.add("named-query");
        names.add("named-native-query");
        names.add("named-stored-procedure-query");
        names.add("named-stored-function-query");
        names.add("named-plsql-stored-procedure-query");
        names.add("named-plsql-stored-function-query");
        names.add("oracle-object");
        names.add("oracle-array");
        names.add("plsql-record");
        names.add("plsql-table");
        names.add("sql-result-set-mapping");
        names.add("query-redirectors");
        names.add("exclude-default-listeners");
        names.add("exclude-superclass-listeners");
        names.add("entity-listeners");
        names.add("pre-persist");
        names.add("post-persist");
        names.add("pre-remove");
        names.add("post-remove");
        names.add("pre-update");
        names.add("post-update");
        names.add("post-load");
        names.add("property");
        names.add("attribute-override");
        names.add("association-override");
        names.add("convert");
        names.add("named-entity-graph");
        names.add("attributes");
        return names;
    }

    private PrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(int index) {
        return new PrimaryKeyJoinColumn(this, index);
    }

    private PrimaryTable buildPrimaryTable() {
        return new PrimaryTable(this);
    }

    private SecondaryTable buildSecondaryTable(int index) {
        return new SecondaryTable(this, index);
    }

    private SQLResultSetMapping buildSqlResultSetMapping(int index) {
        return new SQLResultSetMapping(this, index);
    }

    @Override
    public String getClassExtractorClassName() {
        return this.getChildAttribute("class-extractor", "class");
    }

    @Override
    public TextRange getClassExtractorClassNameTextRange() {
        return this.getChildAttributeTextRange("class-extractor", "class");
    }

    @Override
    public DiscriminatorColumn getDiscriminatorColumn() {
        if (this.hasChild("discriminator-column")) {
            return this.buildDiscriminatorColumn();
        }
        return null;
    }

    @Override
    public String getDiscriminatorValue() {
        return this.getChildTextNode("discriminator-value");
    }

    @Override
    public TextRange getDiscriminatorValueTextRange() {
        return this.getChildTextNodeTextRange("discriminator-value");
    }

    @Override
    protected String getElementName() {
        return "entity";
    }

    @Override
    public InheritanceType getInheritenceStrategy() {
        Element element = this.getChild("inheritance");
        if (element != null) {
            return this.getEnumAttribute(element, "strategy", InheritanceType.class);
        }
        return null;
    }

    @Override
    public TextRange getInheritenceStrategyTextRange() {
        return this.getChildAttributeTextRange("inheritance", "strategy");
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getAttributeTextRange("name");
    }

    @Override
    public ExternalPrimaryKeyJoinColumn getPrimaryKeyJoinColumn(int index) {
        if (this.hasChild("primary-key-join-column", index)) {
            return this.buildPrimaryKeyJoinColumn(index);
        }
        return null;
    }

    @Override
    public ExternalEntityTable getPrimaryTable() {
        if (this.hasPrimaryTable()) {
            return this.buildPrimaryTable();
        }
        return null;
    }

    @Override
    public ExternalSecondaryTable getSecondaryTable(int index) {
        if (this.hasChild("secondary-table")) {
            return this.buildSecondaryTable(index);
        }
        return null;
    }

    @Override
    public ExternalSQLResultSetMapping getSqlResultSetMapping(int index) {
        if (this.hasChild("sql-result-set-mapping", index)) {
            return this.buildSqlResultSetMapping(index);
        }
        return null;
    }

    @Override
    public boolean hasPrimaryTable() {
        return this.hasChild("table");
    }

    @Override
    public List<ExternalPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        int count = this.primaryKeyJoinColumnsSize();
        ArrayList<ExternalPrimaryKeyJoinColumn> pkJoinColumns = new ArrayList<ExternalPrimaryKeyJoinColumn>(count);
        int index = 0;
        while (index < count) {
            pkJoinColumns.add(this.buildPrimaryKeyJoinColumn(index));
            ++index;
        }
        return pkJoinColumns;
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.getChildrenSize("primary-key-join-column");
    }

    @Override
    public void removePrimaryKeyJoinColumn(int index) {
        PrimaryKeyJoinColumn pkJoinColumn = this.buildPrimaryKeyJoinColumn(index);
        pkJoinColumn.removeSelf();
    }

    @Override
    public void removePrimaryTable() {
        PrimaryTable primaryTable = this.buildPrimaryTable();
        primaryTable.removeSelf();
    }

    @Override
    public void removeSecondaryTable(int index) {
        SecondaryTable secondaryTable = this.buildSecondaryTable(index);
        secondaryTable.removeSelf();
    }

    @Override
    public void removeSqlResultSetMapping(int index) {
        SQLResultSetMapping sqlResultSetMapping = this.buildSqlResultSetMapping(index);
        sqlResultSetMapping.removeSelf();
    }

    @Override
    public List<ExternalSecondaryTable> secondaryTables() {
        int count = this.secondaryTablesSize();
        ArrayList<ExternalSecondaryTable> secondaryTables = new ArrayList<ExternalSecondaryTable>(count);
        int index = 0;
        while (index < count) {
            secondaryTables.add(this.buildSecondaryTable(index));
            ++index;
        }
        return secondaryTables;
    }

    @Override
    public int secondaryTablesSize() {
        return this.getChildrenSize("secondary-table");
    }

    @Override
    public void setClassExtractorClassName(String className) {
        this.updateChildAttribute("class-extractor", "class", className);
    }

    @Override
    public void setDiscriminatorValue(String discriminatorValue) {
        this.updateChildTextNode("discriminator-value", discriminatorValue);
    }

    @Override
    public void setInheritanceStrategy(InheritanceType value) {
        this.updateChildAttribute("inheritance", "strategy", (Enum<?>)value);
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public List<ExternalSQLResultSetMapping> sqlResultSetMappings() {
        int count = this.sqlResultSetMappingsSize();
        ArrayList<ExternalSQLResultSetMapping> sqlResultSetMappings = new ArrayList<ExternalSQLResultSetMapping>(count);
        int index = 0;
        while (index < count) {
            sqlResultSetMappings.add(this.buildSqlResultSetMapping(index));
            ++index;
        }
        return sqlResultSetMappings;
    }

    @Override
    public int sqlResultSetMappingsSize() {
        return this.getChildrenSize("sql-result-set-mapping");
    }
}

